/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeListbox;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TreeListboxTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(TreeListboxTag.class);
    private ValueExpression markup;
    private ValueExpression state;
    private ValueExpression required;
    private ValueExpression selectable;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.TreeListbox";
    }

    public String getRendererType() {
        return "TreeListbox";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UITreeListbox component = (UITreeListbox)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.state != null && !this.state.isLiteralText()) {
            component.setValueExpression("state", this.state);
        }
        if (this.required != null) {
            if (!this.required.isLiteralText()) {
                component.setValueExpression("required", this.required);
            } else {
                component.setRequired(Boolean.parseBoolean(this.required.getExpressionString()));
            }
        }
        if (this.selectable != null) {
            component.setValueExpression("selectable", this.selectable);
        }
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public ValueExpression getState() {
        return this.state;
    }

    public void setState(ValueExpression state) {
        this.state = state;
    }

    public ValueExpression getRequired() {
        return this.required;
    }

    public void setRequired(ValueExpression required) {
        this.required = required;
    }

    public ValueExpression getSelectable() {
        return this.selectable;
    }

    public void setSelectable(ValueExpression selectable) {
        this.selectable = selectable;
    }

    public void release() {
        super.release();
        this.markup = null;
        this.state = null;
        this.required = null;
        this.selectable = null;
    }
}

