/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeIcon;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TreeIconTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(TreeIconTag.class);
    private ValueExpression markup;
    private ValueExpression tip;
    private ValueExpression value;
    private ValueExpression disabled;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.TreeIcon";
    }

    public String getRendererType() {
        return "TreeIcon";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UITreeIcon component = (UITreeIcon)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.tip != null) {
            component.setValueExpression("tip", this.tip);
        }
        if (this.value != null) {
            component.setValueExpression("value", this.value);
        }
        if (this.disabled != null) {
            if (!this.disabled.isLiteralText()) {
                component.setValueExpression("disabled", this.disabled);
            } else {
                component.setDisabled(Boolean.parseBoolean(this.disabled.getExpressionString()));
            }
        }
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public ValueExpression getTip() {
        return this.tip;
    }

    public void setTip(ValueExpression tip) {
        this.tip = tip;
    }

    public ValueExpression getValue() {
        return this.value;
    }

    public void setValue(ValueExpression value) {
        this.value = value;
    }

    public ValueExpression getDisabled() {
        return this.disabled;
    }

    public void setDisabled(ValueExpression disabled) {
        this.disabled = disabled;
    }

    public void release() {
        super.release();
        this.markup = null;
        this.tip = null;
        this.value = null;
        this.disabled = null;
    }
}

