/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITab;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TabTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(TabTag.class);
    private ValueExpression markup;
    private ValueExpression accessKey;
    private ValueExpression labelWithAccessKey;
    private ValueExpression label;
    private ValueExpression disabled;
    private ValueExpression tip;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.Tab";
    }

    public String getRendererType() {
        return "Tab";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UITab component = (UITab)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.accessKey != null) {
            if (!this.accessKey.isLiteralText()) {
                component.setValueExpression("accessKey", this.accessKey);
            } else {
                component.setAccessKey(Character.valueOf(this.accessKey.getExpressionString().charAt(0)));
            }
        }
        if (this.labelWithAccessKey != null) {
            component.setValueExpression("labelWithAccessKey", this.labelWithAccessKey);
        }
        if (this.label != null) {
            component.setValueExpression("label", this.label);
        }
        if (this.disabled != null) {
            if (!this.disabled.isLiteralText()) {
                component.setValueExpression("disabled", this.disabled);
            } else {
                component.setDisabled(Boolean.parseBoolean(this.disabled.getExpressionString()));
            }
        }
        if (this.tip != null) {
            component.setValueExpression("tip", this.tip);
        }
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public ValueExpression getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(ValueExpression accessKey) {
        this.accessKey = accessKey;
    }

    public ValueExpression getLabelWithAccessKey() {
        return this.labelWithAccessKey;
    }

    public void setLabelWithAccessKey(ValueExpression labelWithAccessKey) {
        this.labelWithAccessKey = labelWithAccessKey;
    }

    public ValueExpression getLabel() {
        return this.label;
    }

    public void setLabel(ValueExpression label) {
        this.label = label;
    }

    public ValueExpression getDisabled() {
        return this.disabled;
    }

    public void setDisabled(ValueExpression disabled) {
        this.disabled = disabled;
    }

    public ValueExpression getTip() {
        return this.tip;
    }

    public void setTip(ValueExpression tip) {
        this.tip = tip;
    }

    public void release() {
        super.release();
        this.markup = null;
        this.accessKey = null;
        this.labelWithAccessKey = null;
        this.label = null;
        this.disabled = null;
        this.tip = null;
    }
}

