/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIPopup;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.apache.myfaces.tobago.layout.Measure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PopupTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(PopupTag.class);
    private ValueExpression markup;
    private ValueExpression height;
    private ValueExpression left;
    private ValueExpression modal;
    private ValueExpression top;
    private ValueExpression width;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.Popup";
    }

    public String getRendererType() {
        return "Popup";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UIPopup component = (UIPopup)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.height != null) {
            if (!this.height.isLiteralText()) {
                component.setValueExpression("height", this.height);
            } else {
                component.setHeight(Measure.valueOf(this.height.getExpressionString()));
            }
        }
        if (this.left != null) {
            if (!this.left.isLiteralText()) {
                component.setValueExpression("left", this.left);
            } else {
                component.setLeft(Measure.valueOf(this.left.getExpressionString()));
            }
        }
        if (this.modal != null) {
            if (!this.modal.isLiteralText()) {
                component.setValueExpression("modal", this.modal);
            } else {
                component.setModal(Boolean.parseBoolean(this.modal.getExpressionString()));
            }
        }
        if (this.top != null) {
            if (!this.top.isLiteralText()) {
                component.setValueExpression("top", this.top);
            } else {
                component.setTop(Measure.valueOf(this.top.getExpressionString()));
            }
        }
        if (this.width != null) {
            if (!this.width.isLiteralText()) {
                component.setValueExpression("width", this.width);
            } else {
                component.setWidth(Measure.valueOf(this.width.getExpressionString()));
            }
        }
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public ValueExpression getHeight() {
        return this.height;
    }

    public void setHeight(ValueExpression height) {
        this.height = height;
    }

    public ValueExpression getLeft() {
        return this.left;
    }

    public void setLeft(ValueExpression left) {
        this.left = left;
    }

    public ValueExpression getModal() {
        return this.modal;
    }

    public void setModal(ValueExpression modal) {
        this.modal = modal;
    }

    public ValueExpression getTop() {
        return this.top;
    }

    public void setTop(ValueExpression top) {
        this.top = top;
    }

    public ValueExpression getWidth() {
        return this.width;
    }

    public void setWidth(ValueExpression width) {
        this.width = width;
    }

    public void release() {
        super.release();
        this.markup = null;
        this.height = null;
        this.left = null;
        this.modal = null;
        this.top = null;
        this.width = null;
    }
}

