/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIOut;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(OutTag.class);
    private ValueExpression markup;
    private ValueExpression escape;
    private ValueExpression tip;
    private ValueExpression converter;
    private ValueExpression inline;
    private ValueExpression value;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.Out";
    }

    public String getRendererType() {
        return "Out";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UIOut component = (UIOut)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.escape != null) {
            if (!this.escape.isLiteralText()) {
                component.setValueExpression("escape", this.escape);
            } else {
                component.setEscape(Boolean.parseBoolean(this.escape.getExpressionString()));
            }
        }
        if (this.tip != null) {
            component.setValueExpression("tip", this.tip);
        }
        if (this.converter != null) {
            if (!this.converter.isLiteralText()) {
                component.setValueExpression("converter", this.converter);
            } else {
                component.setConverter(application.createConverter(this.converter.getExpressionString()));
            }
        }
        if (this.inline != null) {
            if (!this.inline.isLiteralText()) {
                component.setValueExpression("inline", this.inline);
            } else {
                component.setInline(Boolean.parseBoolean(this.inline.getExpressionString()));
            }
        }
        if (this.value != null) {
            component.setValueExpression("value", this.value);
        }
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public ValueExpression getEscape() {
        return this.escape;
    }

    public void setEscape(ValueExpression escape) {
        this.escape = escape;
    }

    public ValueExpression getTip() {
        return this.tip;
    }

    public void setTip(ValueExpression tip) {
        this.tip = tip;
    }

    public ValueExpression getConverter() {
        return this.converter;
    }

    public void setConverter(ValueExpression converter) {
        this.converter = converter;
    }

    public ValueExpression getInline() {
        return this.inline;
    }

    public void setInline(ValueExpression inline) {
        this.inline = inline;
    }

    public ValueExpression getValue() {
        return this.value;
    }

    public void setValue(ValueExpression value) {
        this.value = value;
    }

    public void release() {
        super.release();
        this.markup = null;
        this.escape = null;
        this.tip = null;
        this.converter = null;
        this.inline = null;
        this.value = null;
    }
}

