/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIMenu;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MenuTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(MenuTag.class);
    private ValueExpression markup;
    private ValueExpression accessKey;
    private ValueExpression labelWithAccessKey;
    private ValueExpression image;
    private ValueExpression label;
    private ValueExpression disabled;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.Menu";
    }

    public String getRendererType() {
        return "Menu";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UIMenu component = (UIMenu)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.accessKey != null) {
            if (!this.accessKey.isLiteralText()) {
                component.setValueExpression("accessKey", this.accessKey);
            } else {
                component.setAccessKey(Character.valueOf(this.accessKey.getExpressionString().charAt(0)));
            }
        }
        if (this.labelWithAccessKey != null) {
            component.setValueExpression("labelWithAccessKey", this.labelWithAccessKey);
        }
        if (this.image != null) {
            component.setValueExpression("image", this.image);
        }
        if (this.label != null) {
            component.setValueExpression("label", this.label);
        }
        if (this.disabled != null) {
            if (!this.disabled.isLiteralText()) {
                component.setValueExpression("disabled", this.disabled);
            } else {
                component.setDisabled(Boolean.parseBoolean(this.disabled.getExpressionString()));
            }
        }
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public ValueExpression getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(ValueExpression accessKey) {
        this.accessKey = accessKey;
    }

    public ValueExpression getLabelWithAccessKey() {
        return this.labelWithAccessKey;
    }

    public void setLabelWithAccessKey(ValueExpression labelWithAccessKey) {
        this.labelWithAccessKey = labelWithAccessKey;
    }

    public ValueExpression getImage() {
        return this.image;
    }

    public void setImage(ValueExpression image) {
        this.image = image;
    }

    public ValueExpression getLabel() {
        return this.label;
    }

    public void setLabel(ValueExpression label) {
        this.label = label;
    }

    public ValueExpression getDisabled() {
        return this.disabled;
    }

    public void setDisabled(ValueExpression disabled) {
        this.disabled = disabled;
    }

    public void release() {
        super.release();
        this.markup = null;
        this.accessKey = null;
        this.labelWithAccessKey = null;
        this.image = null;
        this.label = null;
        this.disabled = null;
    }
}

