/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.MethodExpressionValidator;
import javax.faces.validator.Validator;
import org.apache.myfaces.tobago.component.UIHidden;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiddenTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(HiddenTag.class);
    private ValueExpression converter;
    private MethodExpression validator;
    private ValueExpression value;
    private ValueExpression readonly;
    private ValueExpression disabled;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.Hidden";
    }

    public String getRendererType() {
        return "Hidden";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UIHidden component = (UIHidden)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.converter != null) {
            if (!this.converter.isLiteralText()) {
                component.setValueExpression("converter", this.converter);
            } else {
                component.setConverter(application.createConverter(this.converter.getExpressionString()));
            }
        }
        if (this.validator != null) {
            component.addValidator((Validator)new MethodExpressionValidator(this.validator));
        }
        if (this.value != null) {
            component.setValueExpression("value", this.value);
        }
        if (this.readonly != null) {
            if (!this.readonly.isLiteralText()) {
                component.setValueExpression("readonly", this.readonly);
            } else {
                component.setReadonly(Boolean.parseBoolean(this.readonly.getExpressionString()));
            }
        }
        if (this.disabled != null) {
            if (!this.disabled.isLiteralText()) {
                component.setValueExpression("disabled", this.disabled);
            } else {
                component.setDisabled(Boolean.parseBoolean(this.disabled.getExpressionString()));
            }
        }
    }

    public ValueExpression getConverter() {
        return this.converter;
    }

    public void setConverter(ValueExpression converter) {
        this.converter = converter;
    }

    public MethodExpression getValidator() {
        return this.validator;
    }

    public void setValidator(MethodExpression validator) {
        this.validator = validator;
    }

    public ValueExpression getValue() {
        return this.value;
    }

    public void setValue(ValueExpression value) {
        this.value = value;
    }

    public ValueExpression getReadonly() {
        return this.readonly;
    }

    public void setReadonly(ValueExpression readonly) {
        this.readonly = readonly;
    }

    public ValueExpression getDisabled() {
        return this.disabled;
    }

    public void setDisabled(ValueExpression disabled) {
        this.disabled = disabled;
    }

    public void release() {
        super.release();
        this.converter = null;
        this.validator = null;
        this.value = null;
        this.readonly = null;
        this.disabled = null;
    }
}

