/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.lifecycle;

import java.util.Iterator;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.apache.myfaces.tobago.internal.lifecycle.TobagoLifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TobagoLifecycleFactory
extends LifecycleFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoLifecycleFactory.class);
    private LifecycleFactory factory;
    private TobagoLifecycle defaultLifecycle;

    public TobagoLifecycleFactory(LifecycleFactory factory) {
        this.factory = factory;
        this.defaultLifecycle = new TobagoLifecycle();
        if (LOG.isDebugEnabled()) {
            LOG.debug("new TobagoLifecycleFactory");
        }
    }

    public void addLifecycle(String lifecycleId, Lifecycle lifecycle) {
        this.factory.addLifecycle(lifecycleId, lifecycle);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Lifecycle added : " + lifecycleId + " = " + lifecycle.getClass().getName() + "");
        }
    }

    public Lifecycle getLifecycle(String lifecycleId) {
        if ("DEFAULT".equals(lifecycleId)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getLifecycle(\"" + lifecycleId + "\")  -> TobagoLifecycle");
            }
            return this.defaultLifecycle;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getLifecycle(\"" + lifecycleId + "\")  -> other Lifecycle");
        }
        return this.factory.getLifecycle(lifecycleId);
    }

    public Iterator getLifecycleIds() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getLifecycleIds()");
        }
        return this.factory.getLifecycleIds();
    }
}

