/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.context;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.internal.util.FastStringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseWriterDivider {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseWriterDivider.class);
    private List<ResponseWriter> writers = new ArrayList<ResponseWriter>();
    private List<FastStringWriter> buffers = new ArrayList<FastStringWriter>();
    private ResponseWriter original;
    private int current = -1;
    private String nameInRequest;

    public static ResponseWriterDivider getInstance(FacesContext facesContext, String nameInRequest) {
        Map map = facesContext.getExternalContext().getRequestMap();
        ResponseWriterDivider divider = (ResponseWriterDivider)map.get(nameInRequest);
        if (divider == null) {
            divider = new ResponseWriterDivider(facesContext);
            map.put(nameInRequest, divider);
            divider.nameInRequest = nameInRequest;
        }
        return divider;
    }

    private ResponseWriterDivider(FacesContext facesContext) {
        this.original = facesContext.getResponseWriter();
    }

    public boolean activateBranch(FacesContext facesContext) {
        assert (this.writers.size() == this.buffers.size());
        boolean created = true;
        ++this.current;
        if (this.writers.size() == this.current) {
            FastStringWriter buffer = new FastStringWriter();
            this.buffers.add(buffer);
            ResponseWriter newWriter = facesContext.getResponseWriter().cloneWithWriter((Writer)buffer);
            this.writers.add(newWriter);
            created = false;
        }
        facesContext.setResponseWriter(this.writers.get(this.current));
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.toString());
        }
        return created;
    }

    public boolean passivateBranch(FacesContext facesContext) {
        assert (this.writers.size() == this.buffers.size());
        --this.current;
        if (this.current >= 0) {
            facesContext.setResponseWriter(this.writers.get(this.current));
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.toString());
            }
            return true;
        }
        facesContext.setResponseWriter(this.original);
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.toString());
        }
        return false;
    }

    public void writeOutAndCleanUp(FacesContext facesContext) throws IOException {
        facesContext.setResponseWriter(this.original);
        for (FastStringWriter buffer : this.buffers) {
            this.original.write(buffer.toString());
        }
        Map map = facesContext.getExternalContext().getRequestMap();
        map.remove(this.nameInRequest);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StringBuilder(" + System.identityHashCode(this) + ") current=" + this.current + "\n");
        int i = 0;
        for (FastStringWriter buffer : this.buffers) {
            builder.append("\n- buffer " + i++ + " ------------------------------------------------------------\n");
            builder.append(buffer.toString());
        }
        builder.append("\n-----------------------------------------------------------------------\n");
        return builder.toString();
    }
}

