/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.context;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.UserAgent;
import org.apache.myfaces.tobago.util.VariableResolverUtils;

public final class ClientPropertiesKey
implements Serializable {
    private static final String KEY_IN_REQUEST = ClientPropertiesKey.class.getName();
    private final String contentType;
    private final Theme theme;
    private final UserAgent userAgent;
    private final Locale locale;
    private final int hashCode;

    public static ClientPropertiesKey get(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        ClientPropertiesKey key = (ClientPropertiesKey)requestMap.get(KEY_IN_REQUEST);
        if (key == null) {
            ClientProperties clientProperties = VariableResolverUtils.resolveClientProperties(facesContext);
            key = new ClientPropertiesKey(clientProperties);
            requestMap.put(KEY_IN_REQUEST, key);
        }
        return key;
    }

    public static void reset(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        requestMap.remove(KEY_IN_REQUEST);
    }

    private ClientPropertiesKey(ClientProperties clientProperties) {
        this.contentType = clientProperties.getContentType();
        this.theme = clientProperties.getTheme();
        this.userAgent = clientProperties.getUserAgent();
        this.locale = clientProperties.getLocale();
        this.hashCode = this.calcHashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientPropertiesKey that = (ClientPropertiesKey)o;
        if (!this.contentType.equals(that.contentType)) {
            return false;
        }
        if (this.locale == null ? that.locale != null : !this.locale.equals(that.locale)) {
            return false;
        }
        if (!this.theme.equals(that.theme)) {
            return false;
        }
        return this.userAgent.equals(that.userAgent);
    }

    private int calcHashCode() {
        int result = this.contentType.hashCode();
        result = 31 * result + this.theme.hashCode();
        result = 31 * result + this.userAgent.hashCode();
        if (this.locale != null) {
            result = 31 * result + this.locale.hashCode();
        }
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "ClientPropertiesKey(" + this.contentType + "," + this.theme + "," + this.userAgent + "," + this.locale + "," + this.hashCode + ')';
    }

    public String getContentType() {
        return this.contentType;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

