/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.faces.FacesException;
import org.apache.commons.digester.Digester;
import org.apache.commons.io.IOUtils;
import org.apache.myfaces.tobago.context.ThemeImpl;
import org.apache.myfaces.tobago.context.ThemeResources;
import org.apache.myfaces.tobago.context.ThemeScript;
import org.apache.myfaces.tobago.context.ThemeStyle;
import org.apache.myfaces.tobago.internal.config.RendererConfig;
import org.apache.myfaces.tobago.internal.config.RenderersConfigImpl;
import org.apache.myfaces.tobago.internal.config.TobagoConfigFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class TobagoConfigParser {
    private static final Logger LOG = LoggerFactory.getLogger(TobagoConfigParser.class);
    private static final String TOBAGO_CONFIG_DTD_1_0 = "/org/apache/myfaces/tobago/config/tobago-config_1_0.dtd";
    private static final String TOBAGO_CONFIG_DTD_1_0_29 = "/org/apache/myfaces/tobago/config/tobago-config-1.0.29.dtd";
    private static final String TOBAGO_CONFIG_DTD_1_0_30 = "/org/apache/myfaces/tobago/config/tobago-config-1.0.30.dtd";
    private static final String TOBAGO_CONFIG_DTD_1_0_34 = "/org/apache/myfaces/tobago/config/tobago-config-1.0.34.dtd";
    private static final String TOBAGO_CONFIG_XSD_1_5 = "/org/apache/myfaces/tobago/config/tobago-config-1.5.xsd";
    private Digester digester = new Digester();

    public TobagoConfigParser() {
        this.digester.setUseContextClassLoader(true);
        this.configure();
        this.registerDtds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TobagoConfigFragment parse(URL url) throws IOException, SAXException, FacesException {
        if (LOG.isInfoEnabled()) {
            LOG.info("Parsing configuration file: '{}'", (Object)url);
        }
        TobagoConfigFragment tobagoConfig = new TobagoConfigFragment();
        this.digester.push((Object)tobagoConfig);
        InputStream inputStream = null;
        try {
            this.configureValidation(url);
            inputStream = url.openStream();
            this.digester.parse(inputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return tobagoConfig;
    }

    private void configureValidation(URL url) {
        try {
            String xml = IOUtils.toString((InputStream)url.openStream());
            if (xml.indexOf("tobago-config-1.5.xsd") > 0) {
                this.digester.setValidating(false);
                return;
            }
        }
        catch (Exception e) {
            LOG.warn("Error while checking: '" + url + "'", (Throwable)e);
        }
        this.digester.setValidating(true);
    }

    private Digester configure() {
        this.digester.addCallMethod("tobago-config/name", "setName", 0);
        this.digester.addCallMethod("tobago-config/ordering/before/name", "addBefore", 0);
        this.digester.addCallMethod("tobago-config/ordering/after/name", "addAfter", 0);
        this.digester.addCallMethod("tobago-config/theme-config/default-theme", "setDefaultThemeName", 0);
        this.digester.addCallMethod("tobago-config/theme-config/supported-theme", "addSupportedThemeName", 0);
        this.digester.addCallMethod("tobago-config/resource-dir", "addResourceDir", 0);
        this.digester.addCallMethod("tobago-config/ajax-enabled", "setAjaxEnabled", 0);
        this.digester.addCallMethod("tobago-config/fix-resource-order", "setFixResourceOrder", 0);
        this.digester.addCallMethod("tobago-config/fix-layout-transparency", "setFixLayoutTransparency", 0);
        this.digester.addCallMethod("tobago-config/create-session-secret", "setCreateSessionSecret", 0);
        this.digester.addCallMethod("tobago-config/check-session-secret", "setCheckSessionSecret", 0);
        this.digester.addObjectCreate("tobago-config/renderers", RenderersConfigImpl.class);
        this.digester.addSetNext("tobago-config/renderers", "setRenderersConfig");
        this.digester.addObjectCreate("tobago-config/renderers/renderer", RendererConfig.class);
        this.digester.addSetNext("tobago-config/renderers/renderer", "addRenderer");
        this.digester.addCallMethod("tobago-config/renderers/renderer/name", "setName", 0);
        this.digester.addCallMethod("tobago-config/renderers/renderer/supported-markup/markup", "addSupportedMarkup", 0);
        this.digester.addObjectCreate("tobago-config/theme-definitions/theme-definition", ThemeImpl.class);
        this.digester.addSetNext("tobago-config/theme-definitions/theme-definition", "addThemeDefinition");
        this.digester.addCallMethod("tobago-config/theme-definitions/theme-definition/name", "setName", 0);
        this.digester.addCallMethod("tobago-config/theme-definitions/theme-definition/deprecated-name", "setDeprecatedName", 0);
        this.digester.addCallMethod("tobago-config/theme-definitions/theme-definition/display-name", "setDisplayName", 0);
        this.digester.addCallMethod("tobago-config/theme-definitions/theme-definition/resource-path", "setResourcePath", 0);
        this.digester.addCallMethod("tobago-config/theme-definitions/theme-definition/fallback", "setFallbackName", 0);
        this.digester.addObjectCreate("tobago-config/theme-definitions/theme-definition/renderers", RenderersConfigImpl.class);
        this.digester.addSetNext("tobago-config/theme-definitions/theme-definition/renderers", "setRenderersConfig");
        this.digester.addObjectCreate("tobago-config/theme-definitions/theme-definition/renderers/renderer", RendererConfig.class);
        this.digester.addSetNext("tobago-config/theme-definitions/theme-definition/renderers/renderer", "addRenderer");
        this.digester.addCallMethod("tobago-config/theme-definitions/theme-definition/renderers/renderer/name", "setName", 0);
        this.digester.addCallMethod("tobago-config/theme-definitions/theme-definition/renderers/renderer/supported-markup/markup", "addSupportedMarkup", 0);
        this.digester.addObjectCreate("tobago-config/theme-definitions/theme-definition/resources", ThemeResources.class);
        this.digester.addSetProperties("tobago-config/theme-definitions/theme-definition/resources");
        this.digester.addSetNext("tobago-config/theme-definitions/theme-definition/resources", "addResources");
        this.digester.addObjectCreate("tobago-config/theme-definitions/theme-definition/resources/script", ThemeScript.class);
        this.digester.addSetProperties("tobago-config/theme-definitions/theme-definition/resources/script");
        this.digester.addSetNext("tobago-config/theme-definitions/theme-definition/resources/script", "addScript");
        this.digester.addObjectCreate("tobago-config/theme-definitions/theme-definition/resources/style", ThemeStyle.class);
        this.digester.addSetProperties("tobago-config/theme-definitions/theme-definition/resources/style");
        this.digester.addSetNext("tobago-config/theme-definitions/theme-definition/resources/style", "addStyle");
        return this.digester;
    }

    private void registerDtds() {
        this.registerDtd("-//Atanion GmbH//DTD Tobago Config 1.0//EN", TOBAGO_CONFIG_DTD_1_0);
        this.registerDtd("-//The Apache Software Foundation//DTD Tobago Config 1.0//EN", TOBAGO_CONFIG_DTD_1_0);
        this.registerDtd("-//The Apache Software Foundation//DTD Tobago Config 1.0.29//EN", TOBAGO_CONFIG_DTD_1_0_29);
        this.registerDtd("-//The Apache Software Foundation//DTD Tobago Config 1.0.30//EN", TOBAGO_CONFIG_DTD_1_0_30);
        this.registerDtd("-//The Apache Software Foundation//DTD Tobago Config 1.0.34//EN", TOBAGO_CONFIG_DTD_1_0_34);
    }

    private void registerDtd(String publicId, String entityUrl) {
        URL url = TobagoConfigParser.class.getResource(entityUrl);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering dtd: url='{}'", (Object)url);
        }
        if (null != url) {
            this.digester.register(publicId, url.toString());
        } else {
            LOG.warn("Unable to retrieve local DTD '" + entityUrl + "'; trying external URL");
        }
    }
}

