/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.faces.FacesException;
import org.apache.commons.digester.Digester;
import org.apache.commons.io.IOUtils;
import org.apache.myfaces.tobago.context.ThemeImpl;
import org.apache.myfaces.tobago.context.ThemeResources;
import org.apache.myfaces.tobago.context.ThemeScript;
import org.apache.myfaces.tobago.context.ThemeStyle;
import org.apache.myfaces.tobago.internal.config.RendererConfig;
import org.apache.myfaces.tobago.internal.config.RenderersConfigImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ThemeParser {
    private static final Logger LOG = LoggerFactory.getLogger(ThemeParser.class);
    private Digester digester;

    public ThemeParser() {
        this.configure();
    }

    private void configure() {
        this.digester = new Digester();
        this.digester.setUseContextClassLoader(true);
        this.digester.setValidating(false);
        this.digester.addCallMethod("tobago-theme/name", "setName", 0);
        this.digester.addCallMethod("tobago-theme/deprecated-name", "setDeprecatedName", 0);
        this.digester.addCallMethod("tobago-theme/display-name", "setDisplayName", 0);
        this.digester.addCallMethod("tobago-theme/resource-path", "setResourcePath", 0);
        this.digester.addCallMethod("tobago-theme/fallback", "setFallbackName", 0);
        this.digester.addObjectCreate("tobago-theme/renderers", RenderersConfigImpl.class);
        this.digester.addSetNext("tobago-theme/renderers", "setRenderersConfig");
        this.digester.addObjectCreate("tobago-theme/renderers/renderer", RendererConfig.class);
        this.digester.addSetNext("tobago-theme/renderers/renderer", "addRenderer");
        this.digester.addCallMethod("tobago-theme/renderers/renderer/name", "setName", 0);
        this.digester.addCallMethod("tobago-theme/renderers/renderer/supported-markup/markup", "addSupportedMarkup", 0);
        this.digester.addObjectCreate("tobago-theme/resources", ThemeResources.class);
        this.digester.addSetProperties("tobago-theme/resources");
        this.digester.addSetNext("tobago-theme/resources", "addResources");
        this.digester.addObjectCreate("tobago-theme/resources/script", ThemeScript.class);
        this.digester.addSetProperties("tobago-theme/resources/script");
        this.digester.addSetNext("tobago-theme/resources/script", "addScript");
        this.digester.addObjectCreate("tobago-theme/resources/style", ThemeStyle.class);
        this.digester.addSetProperties("tobago-theme/resources/style");
        this.digester.addSetNext("tobago-theme/resources/style", "addStyle");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThemeImpl parse(URL url) throws IOException, SAXException, FacesException {
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            ThemeImpl theme = new ThemeImpl();
            this.digester.push((Object)theme);
            this.digester.parse(inputStream);
            if (LOG.isInfoEnabled()) {
                LOG.info("Found theme: '" + theme.getName() + "'");
            }
            if (theme.getDisplayName() == null) {
                LOG.warn("No display name set for theme: '" + theme.getName() + "'");
                theme.setDisplayName(theme.getName());
            }
            ThemeImpl themeImpl = theme;
            return themeImpl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }
}

