/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.tobago.component.TreeModelBuilder;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeData;
import org.apache.myfaces.tobago.internal.component.AbstractUITreeNode;
import org.apache.myfaces.tobago.layout.LayoutComponent;
import org.apache.myfaces.tobago.model.MixedTreeModel;
import org.apache.myfaces.tobago.model.TreeSelectable;
import org.apache.myfaces.tobago.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUITree
extends UIInput
implements NamingContainer,
LayoutComponent {
    public static final String MESSAGE_NOT_LEAF = "tobago.tree.MESSAGE_NOT_LEAF";
    public static final String SEP = "-";
    public static final String SELECT_STATE = "-selectState";
    public static final String MARKED = "marked";
    private MixedTreeModel model;
    private Set<String> expandedCache;

    public UIComponent getRoot() {
        for (UIComponent child : this.getChildren()) {
            if (child instanceof AbstractUITreeNode) {
                return child;
            }
            if (!(child instanceof AbstractUITreeData)) continue;
            return child;
        }
        return null;
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        this.model = new MixedTreeModel();
        this.expandedCache = new HashSet<String>();
        for (Object child : this.getChildren()) {
            if (!(child instanceof TreeModelBuilder)) continue;
            TreeModelBuilder builder = (TreeModelBuilder)child;
            builder.buildTreeModelBegin(facesContext, this.model);
            builder.buildTreeModelChildren(facesContext, this.model);
            builder.buildTreeModelEnd(facesContext, this.model);
        }
        super.encodeEnd(facesContext);
        this.model = null;
        this.expandedCache = null;
    }

    public MixedTreeModel getModel() {
        return this.model;
    }

    public Set<String> getExpandedCache() {
        return this.expandedCache;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public TreeSelectable getSelectableAsEnum() {
        return TreeSelectable.parse(ComponentUtils.getStringAttribute((UIComponent)this, "selectable"));
    }

    public void processDecodes(FacesContext facesContext) {
        if (!this.isRendered()) {
            return;
        }
        if (ComponentUtils.isOutputOnly((UIComponent)this)) {
            this.setValid(true);
        } else {
            this.decode(facesContext);
            Iterator i = this.getFacetsAndChildren();
            while (i.hasNext()) {
                UIComponent uiComponent = (UIComponent)i.next();
                uiComponent.processDecodes(facesContext);
            }
        }
    }

    public void validate(FacesContext context) {
        if (this.getValidators() != null) {
            for (Validator validator : this.getValidators()) {
                try {
                    validator.validate(context, (UIComponent)this, null);
                }
                catch (ValidatorException ve) {
                    this.setValid(false);
                    FacesMessage message = ve.getFacesMessage();
                    if (message == null) continue;
                    message.setSeverity(FacesMessage.SEVERITY_ERROR);
                    context.addMessage(this.getClientId(context), message);
                }
            }
        }
    }

    public void updateModel(FacesContext facesContext) {
    }

    public abstract Object getState();
}

