/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.util.List;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumn;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnSelector;
import org.apache.myfaces.tobago.internal.component.AbstractUILayoutBase;
import org.apache.myfaces.tobago.internal.component.AbstractUISheet;
import org.apache.myfaces.tobago.internal.layout.IntervalList;
import org.apache.myfaces.tobago.internal.layout.LayoutUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.AutoLayoutToken;
import org.apache.myfaces.tobago.layout.Display;
import org.apache.myfaces.tobago.layout.LayoutComponent;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.LayoutManager;
import org.apache.myfaces.tobago.layout.LayoutToken;
import org.apache.myfaces.tobago.layout.LayoutTokens;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.Orientation;
import org.apache.myfaces.tobago.layout.RelativeLayoutToken;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRenderer;
import org.apache.myfaces.tobago.util.LayoutInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUISheetLayout
extends AbstractUILayoutBase
implements LayoutManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUISheetLayout.class);
    private boolean horizontalAuto;
    private boolean verticalAuto;

    @Override
    public void init() {
        for (LayoutComponent component : this.getLayoutContainer().getComponents()) {
            if (!(component instanceof LayoutContainer) || !component.isRendered()) continue;
            ((LayoutContainer)((Object)component)).getLayoutManager().init();
        }
    }

    @Override
    public void fixRelativeInsideAuto(Orientation orientation, boolean auto) {
        if (orientation == Orientation.HORIZONTAL) {
            this.horizontalAuto = auto;
        } else {
            this.verticalAuto = auto;
        }
        for (LayoutComponent component : this.getLayoutContainer().getComponents()) {
            if (!(component instanceof LayoutContainer) || !component.isRendered()) continue;
            ((LayoutContainer)((Object)component)).getLayoutManager().fixRelativeInsideAuto(orientation, auto);
        }
    }

    @Override
    public void preProcessing(Orientation orientation) {
        IntervalList intervals = new IntervalList();
        for (LayoutComponent component : this.getLayoutContainer().getComponents()) {
            if (component == null || !(component instanceof LayoutContainer) || !component.isRendered()) continue;
            ((LayoutContainer)((Object)component)).getLayoutManager().preProcessing(orientation);
        }
    }

    @Override
    public void mainProcessing(Orientation orientation) {
        if (orientation == Orientation.HORIZONTAL && !this.horizontalAuto || orientation == Orientation.VERTICAL && !this.verticalAuto) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            LayoutContainer container = this.getLayoutContainer();
            AbstractUISheet sheet = (AbstractUISheet)container;
            if (orientation == Orientation.HORIZONTAL) {
                this.ensureColumnWidthList(facesContext, sheet);
                List<Integer> widthList = sheet.getWidthList();
                int index = 0;
                for (LayoutComponent component : sheet.getComponents()) {
                    if (component == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("fixme: UIColumnSelector must be a LayoutComponent!");
                        }
                        ++index;
                        continue;
                    }
                    AbstractUIColumn column = (AbstractUIColumn)((UIComponent)component).getParent();
                    if (!column.isRendered()) continue;
                    Measure width = Measure.valueOf(widthList.get(index));
                    width = width.subtractNotNegative(LayoutUtils.getBorderBegin(orientation, column));
                    width = width.subtractNotNegative(LayoutUtils.getPaddingBegin(orientation, column));
                    width = width.subtractNotNegative(LayoutUtils.getPaddingEnd(orientation, column));
                    width = width.subtractNotNegative(LayoutUtils.getBorderEnd(orientation, column));
                    LayoutComponentRenderer renderer = sheet.getLayoutComponentRenderer(facesContext);
                    width = width.subtractNotNegative(renderer.getCustomMeasure(facesContext, sheet, "columnSeparator"));
                    LayoutUtils.setCurrentSize(orientation, component, width);
                    component.setDisplay(Display.BLOCK);
                    if (component instanceof LayoutContainer && component.isRendered()) {
                        ((LayoutContainer)((Object)component)).getLayoutManager().mainProcessing(orientation);
                    }
                    ++index;
                }
            }
        }
    }

    @Override
    public void postProcessing(Orientation orientation) {
        AbstractUISheet sheet = (AbstractUISheet)this.getLayoutContainer();
        for (LayoutComponent component : sheet.getComponents()) {
            if (component == null) continue;
            Measure position = LayoutUtils.getBorderBegin(orientation, sheet);
            if (orientation == Orientation.HORIZONTAL) {
                component.setLeft(position);
            } else {
                component.setTop(position);
            }
            if (!(component instanceof LayoutContainer) || !component.isRendered()) continue;
            ((LayoutContainer)((Object)component)).getLayoutManager().postProcessing(orientation);
        }
    }

    private LayoutContainer getLayoutContainer() {
        return (LayoutContainer)this.getParent();
    }

    public boolean getRendersChildren() {
        return false;
    }

    private void ensureColumnWidthList(FacesContext facesContext, AbstractUISheet data) {
        List<Integer> currentWidthList = null;
        List<UIColumn> renderedColumns = data.getRenderedColumns();
        Map attributes = data.getAttributes();
        String widthListString = null;
        SheetState state = data.getSheetState(facesContext);
        if (state != null) {
            widthListString = state.getColumnWidths();
        }
        if (widthListString == null) {
            widthListString = (String)attributes.get("widthListString");
        }
        if (widthListString != null) {
            currentWidthList = StringUtils.parseIntegerList(widthListString);
        }
        if (currentWidthList != null && currentWidthList.size() != renderedColumns.size()) {
            currentWidthList = null;
        }
        if (currentWidthList == null) {
            LayoutTokens tokens = data.getColumnLayout();
            List<UIColumn> allColumns = data.getAllColumns();
            LayoutTokens newTokens = new LayoutTokens();
            for (int i = 0; i < allColumns.size(); ++i) {
                UIColumn column = allColumns.get(i);
                if (!column.isRendered()) continue;
                if (tokens == null) {
                    if (column instanceof AbstractUIColumn && ((AbstractUIColumn)column).getWidth() != null) {
                        newTokens.addToken(LayoutTokens.parseToken(((AbstractUIColumn)column).getWidth()));
                        continue;
                    }
                    newTokens.addToken(RelativeLayoutToken.DEFAULT_INSTANCE);
                    continue;
                }
                if (i < tokens.getSize()) {
                    newTokens.addToken(tokens.get(i));
                    continue;
                }
                newTokens.addToken(RelativeLayoutToken.DEFAULT_INSTANCE);
            }
            Measure space = data.getCurrentWidth();
            LayoutComponentRenderer renderer = data.getLayoutComponentRenderer(facesContext);
            space = space.subtractNotNegative(renderer.getBorderLeft(facesContext, data));
            space = space.subtractNotNegative(renderer.getBorderRight(facesContext, data));
            if (this.needVerticalScrollbar(facesContext, data)) {
                space = space.subtractNotNegative(renderer.getVerticalScrollbarWeight(facesContext, data));
            }
            LayoutInfo layoutInfo = new LayoutInfo(newTokens.getSize(), space.getPixel(), newTokens, data.getClientId(facesContext), false);
            Measure columnSelectorWidth = data.getLayoutComponentRenderer(facesContext).getCustomMeasure(facesContext, data, "columnSelectorWidth");
            this.parseFixedWidth(layoutInfo, renderedColumns, columnSelectorWidth);
            layoutInfo.parseColumnLayout(space.getPixel());
            currentWidthList = layoutInfo.getSpaceList();
        }
        if (currentWidthList != null) {
            if (renderedColumns.size() != currentWidthList.size()) {
                LOG.warn("widthList.size() = " + currentWidthList.size() + " != columns.size() = " + renderedColumns.size() + "  widthList : " + LayoutInfo.listToTokenString(currentWidthList));
            } else {
                data.setWidthList(currentWidthList);
            }
        }
    }

    private boolean needVerticalScrollbar(FacesContext facesContext, AbstractUISheet sheet) {
        if (sheet.getNeedVerticalScrollbar() != null) {
            return sheet.getNeedVerticalScrollbar();
        }
        Boolean result = null;
        Object forceScrollbar = sheet.getAttributes().get("forceVerticalScrollbar");
        if (forceScrollbar != null) {
            if ("true".equals(forceScrollbar)) {
                result = true;
            } else if ("false".equals(forceScrollbar)) {
                result = false;
            } else if (!"auto".equals(forceScrollbar)) {
                LOG.warn("Illegal value for attribute 'forceVerticalScrollbar': '" + forceScrollbar + "'");
            }
        }
        if (result == null && !sheet.hasRowCount()) {
            result = true;
        }
        if (result == null) {
            if (sheet.getCurrentHeight() != null) {
                int first = sheet.getFirst();
                int rows = sheet.isRowsUnlimited() ? sheet.getRowCount() : Math.min(sheet.getRowCount(), first + sheet.getRows()) - first;
                Measure heightNeeded = this.getRowHeight(facesContext, sheet).multiply(rows);
                if (sheet.isShowHeader()) {
                    heightNeeded = heightNeeded.add(this.getHeaderHeight(facesContext, sheet));
                }
                if (sheet.isPagingVisible()) {
                    heightNeeded = heightNeeded.add(this.getFooterHeight(facesContext, sheet));
                }
                result = heightNeeded.greaterThan(sheet.getCurrentHeight());
            } else {
                result = false;
            }
        }
        sheet.setNeedVerticalScrollbar(result);
        return result;
    }

    private void parseFixedWidth(LayoutInfo layoutInfo, List<UIColumn> renderedColumns, Measure columnSelectorWidth) {
        LayoutTokens tokens = layoutInfo.getLayoutTokens();
        for (int i = 0; i < tokens.getSize(); ++i) {
            LayoutToken token = tokens.get(i);
            if (!(token instanceof AutoLayoutToken)) continue;
            int width = 0;
            if (!renderedColumns.isEmpty()) {
                if (i < renderedColumns.size()) {
                    UIColumn column = renderedColumns.get(i);
                    if (column instanceof AbstractUIColumnSelector) {
                        width = columnSelectorWidth.getPixel();
                    } else {
                        for (UIComponent component : column.getChildren()) {
                            width += 100;
                        }
                    }
                    layoutInfo.update(width, i);
                } else {
                    layoutInfo.update(0, i);
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("More LayoutTokens found than rows! skipping!");
                    }
                }
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("set column " + i + " from 'auto' to width " + width);
        }
    }

    private Measure getHeaderHeight(FacesContext facesContext, AbstractUISheet sheet) {
        return sheet.isShowHeader() ? sheet.getLayoutComponentRenderer(facesContext).getCustomMeasure(facesContext, sheet, "headerHeight") : Measure.ZERO;
    }

    private Measure getRowHeight(FacesContext facesContext, AbstractUISheet sheet) {
        return sheet.getLayoutComponentRenderer(facesContext).getCustomMeasure(facesContext, sheet, "rowHeight");
    }

    private Measure getFooterHeight(FacesContext facesContext, AbstractUISheet sheet) {
        return sheet.isPagingVisible() ? sheet.getLayoutComponentRenderer(facesContext).getCustomMeasure(facesContext, sheet, "footerHeight") : Measure.ZERO;
    }
}

