/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.collections.KeyValue;
import org.apache.myfaces.tobago.compat.FacesUtils;
import org.apache.myfaces.tobago.component.DeprecatedDimension;
import org.apache.myfaces.tobago.component.OnComponentPopulated;
import org.apache.myfaces.tobago.internal.component.AbstractUIForm;
import org.apache.myfaces.tobago.internal.component.AbstractUILayoutBase;
import org.apache.myfaces.tobago.internal.layout.LayoutUtils;
import org.apache.myfaces.tobago.internal.webapp.TobagoMultipartFormdataRequest;
import org.apache.myfaces.tobago.layout.Box;
import org.apache.myfaces.tobago.layout.LayoutComponent;
import org.apache.myfaces.tobago.layout.LayoutContainer;
import org.apache.myfaces.tobago.layout.LayoutManager;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.model.PageState;
import org.apache.myfaces.tobago.model.PageStateImpl;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.CreateComponentUtils;
import org.apache.myfaces.tobago.util.DebugUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUIPage
extends AbstractUIForm
implements OnComponentPopulated,
LayoutContainer,
DeprecatedDimension {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractUIPage.class);
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tobago.Page";
    public static final String FORM_ACCEPT_CHARSET = "utf-8";
    private String formId;
    private String actionId;
    private Box actionPosition;
    private String defaultActionId;
    private List<KeyValue> postfields;

    public boolean getRendersChildren() {
        return true;
    }

    public String getFormId(FacesContext facesContext) {
        if (this.formId == null) {
            this.formId = this.getClientId(facesContext) + "::" + "form";
        }
        return this.formId;
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        super.encodeBegin(facesContext);
        ((AbstractUILayoutBase)((Object)this.getLayoutManager())).encodeBegin(facesContext);
    }

    public void encodeChildren(FacesContext facesContext) throws IOException {
        ((AbstractUILayoutBase)((Object)this.getLayoutManager())).encodeChildren(facesContext);
    }

    public void encodeEnd(FacesContext facesContext) throws IOException {
        ((AbstractUILayoutBase)((Object)this.getLayoutManager())).encodeEnd(facesContext);
        super.encodeEnd(facesContext);
    }

    @Override
    public void processDecodes(FacesContext facesContext) {
        this.checkTobagoRequest(facesContext);
        this.decode(facesContext);
        this.markSubmittedForm(facesContext);
        Iterator kids = this.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            kid.processDecodes(facesContext);
        }
    }

    public void markSubmittedForm(FacesContext facesContext) {
        this.setSubmitted(false);
        String currentActionId = this.getActionId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("actionId = '" + currentActionId + "'");
        }
        UIComponent command = null;
        try {
            command = this.findComponent(currentActionId);
        }
        catch (Exception e) {
            LOG.warn("Should not happen!!! currentActionId='" + currentActionId + "'");
        }
        if (command == null && currentActionId != null && currentActionId.matches(".*:\\d+:.*")) {
            currentActionId = currentActionId.replaceAll(":\\d+:", ":");
            try {
                command = this.findComponent(currentActionId);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace(currentActionId);
            LOG.trace("command:{}", (Object)command);
            LOG.trace(DebugUtils.toString((UIComponent)facesContext.getViewRoot(), 0));
        }
        if (command != null) {
            AbstractUIForm form = ComponentUtils.findForm(command);
            form.setSubmitted(true);
            if (LOG.isTraceEnabled()) {
                LOG.trace("form:{}", (Object)form);
                LOG.trace(form.getClientId(facesContext));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Illegal actionId! Rerender the view.");
            }
            facesContext.renderResponse();
        }
    }

    private void checkTobagoRequest(FacesContext facesContext) {
        String contentType = (String)facesContext.getExternalContext().getRequestHeaderMap().get("content-type");
        if (contentType != null && contentType.startsWith("multipart/form-data")) {
            ServletRequest wrappedRequest;
            Object request = facesContext.getExternalContext().getRequest();
            boolean okay = false;
            if (request instanceof TobagoMultipartFormdataRequest) {
                okay = true;
            } else if (request instanceof HttpServletRequestWrapper && (wrappedRequest = ((HttpServletRequestWrapper)request).getRequest()) instanceof TobagoMultipartFormdataRequest) {
                okay = true;
            }
            if (!okay) {
                LOG.error("Can't process multipart/form-data without TobagoRequest. Please check the web.xml and define a TobagoMultipartFormdataFilter. See documentation for <tc:file>");
                facesContext.addMessage(null, new FacesMessage("An error has occured!"));
            }
        }
    }

    public List<KeyValue> getPostfields() {
        if (this.postfields == null) {
            this.postfields = new ArrayList<KeyValue>();
        }
        return this.postfields;
    }

    @Override
    public void processUpdates(FacesContext context) {
        super.processUpdates(context);
        this.updatePageState(context);
    }

    @Deprecated
    public void updatePageState(FacesContext facesContext) {
    }

    @Deprecated
    public PageState getPageState(FacesContext facesContext) {
        if (FacesUtils.hasValueBindingOrValueExpression((UIComponent)this, (String)"state")) {
            PageState state = (PageState)FacesUtils.getValueFromValueBindingOrValueExpression((FacesContext)facesContext, (UIComponent)this, (String)"state");
            if (state == null) {
                state = new PageStateImpl();
                FacesUtils.setValueOfBindingOrExpression((FacesContext)facesContext, (Object)state, (UIComponent)this, (String)"state");
            }
            return state;
        }
        return null;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public Box getActionPosition() {
        return this.actionPosition;
    }

    public void setActionPosition(Box actionPosition) {
        this.actionPosition = actionPosition;
    }

    public String getDefaultActionId() {
        return this.defaultActionId;
    }

    public void setDefaultActionId(String defaultActionId) {
        this.defaultActionId = defaultActionId;
    }

    public void onComponentPopulated(FacesContext facesContext, UIComponent parent) {
        if (this.getLayoutManager() == null) {
            this.setLayoutManager(CreateComponentUtils.createAndInitLayout(facesContext, "org.apache.myfaces.tobago.GridLayout", "GridLayout", parent));
        }
    }

    @Override
    public List<LayoutComponent> getComponents() {
        return LayoutUtils.findLayoutChildren(this);
    }

    @Override
    public LayoutManager getLayoutManager() {
        return (LayoutManager)this.getFacet("layout");
    }

    @Override
    public void setLayoutManager(LayoutManager layoutManager) {
        this.getFacets().put("layout", (AbstractUILayoutBase)((Object)layoutManager));
    }

    @Override
    public boolean isLayoutChildren() {
        return this.isRendered();
    }

    @Override
    public abstract Measure getWidth();

    @Override
    public abstract Measure getHeight();
}

