/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.apache.myfaces.tobago.context.Capability;
import org.apache.myfaces.tobago.internal.util.Deprecation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserAgent
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final String DEFAULT_NAME = "standard";
    public static final UserAgent DEFAULT = new UserAgent(null, null);
    public static final UserAgent MSIE = new UserAgent("msie", null);
    @Deprecated
    public static final UserAgent MSIE_5_0 = new UserAgent("msie", "5_0");
    @Deprecated
    public static final UserAgent MSIE_5_5 = new UserAgent("msie", "5_5");
    public static final UserAgent MSIE_6_0 = new UserAgent("msie", "6_0");
    public static final UserAgent MSIE_7_0 = new UserAgent("msie", "7_0");
    public static final UserAgent MSIE_7_0_COMPAT = new UserAgent("msie", "7_0", EnumSet.of(Capability.IE_COMPATIBILITY_MODE));
    @Deprecated
    public static final UserAgent MSIE_7_O = MSIE_7_0;
    public static final UserAgent MSIE_8_0 = new UserAgent("msie", "8_0");
    public static final UserAgent MSIE_9_0 = new UserAgent("msie", "9_0", EnumSet.of(Capability.CONTENT_TYPE_XHTML));
    public static final UserAgent MSIE_10_0 = new UserAgent("msie", "10_0", EnumSet.of(Capability.CONTENT_TYPE_XHTML));
    @Deprecated
    public static final UserAgent MSIE_5_0_MAC = new UserAgent("msie", "5_0_mac");
    @Deprecated
    public static final UserAgent MSIE_6_0_MAC = new UserAgent("msie", "6_0_mac");
    public static final UserAgent PRESTO = new UserAgent("presto", null, EnumSet.of(Capability.CONTENT_TYPE_XHTML));
    public static final UserAgent OPERA = new UserAgent("opera", null);
    @Deprecated
    public static final UserAgent OPERA_5_0 = new UserAgent("opera", "5_0");
    @Deprecated
    public static final UserAgent OPERA_6_0 = new UserAgent("opera", "6_0");
    @Deprecated
    public static final UserAgent OPERA_7_11 = new UserAgent("opera", "7_11");
    @Deprecated
    public static final UserAgent MOZILLA = new UserAgent("mozilla", null);
    @Deprecated
    public static final UserAgent MOZILLA_4_7 = new UserAgent("mozilla", "4_7");
    @Deprecated
    public static final UserAgent MOZILLA_5_0 = new UserAgent("mozilla", "5_0");
    @Deprecated
    public static final UserAgent MOZILLA_5_0_R1_6 = new UserAgent("mozilla", "5_0_r1_6");
    public static final UserAgent GECKO = new UserAgent("gecko", null, EnumSet.of(Capability.CONTENT_TYPE_XHTML));
    public static final UserAgent GECKO_1_8 = new UserAgent("gecko", "1_8", EnumSet.of(Capability.CONTENT_TYPE_XHTML));
    public static final UserAgent GECKO_1_9 = new UserAgent("gecko", "1_9", EnumSet.of(Capability.CONTENT_TYPE_XHTML));
    public static final UserAgent GECKO_2_0 = new UserAgent("gecko", "2_0", EnumSet.of(Capability.PLACEHOLDER, Capability.CONTENT_TYPE_XHTML));
    public static final UserAgent GECKO_5_0 = new UserAgent("gecko", "5_0", EnumSet.of(Capability.PLACEHOLDER, Capability.CONTENT_TYPE_XHTML));
    public static final UserAgent WEBKIT = new UserAgent("webkit", null, EnumSet.of(Capability.PLACEHOLDER, Capability.CONTENT_TYPE_XHTML));
    private final String name;
    private final String version;
    private final EnumSet<Capability> capabilities;

    private UserAgent(String name, String version) {
        this(name, version, EnumSet.of(Capability.CONTENT_TYPE_XHTML));
    }

    private UserAgent(String name, String version, EnumSet<Capability> capabilities) {
        this.name = name;
        this.version = version;
        this.capabilities = capabilities;
    }

    public boolean hasCapability(Capability capability) {
        return this.capabilities.contains((Object)capability);
    }

    public boolean isMsie() {
        return UserAgent.MSIE.name.equals(this.name);
    }

    public boolean isMsie6() {
        return UserAgent.MSIE_6_0.name.equals(this.name) && UserAgent.MSIE_6_0.version.equals(this.version);
    }

    @Deprecated
    public boolean isMozilla() {
        return UserAgent.MOZILLA.name.equals(this.name);
    }

    public List<String> getFallbackList() {
        return this.getFallbackList(false);
    }

    private List<String> getFallbackList(boolean reverseOrder) {
        ArrayList<String> list = new ArrayList<String>(3);
        if (this.version != null) {
            list.add(this.name + '_' + this.version);
        }
        if (this.name != null) {
            list.add(this.name);
        }
        list.add(DEFAULT_NAME);
        if (reverseOrder) {
            Collections.reverse(list);
        }
        return list;
    }

    public static UserAgent getInstance(String header) {
        if (header == null) {
            return DEFAULT;
        }
        if (header.contains("MSIE")) {
            if (header.contains("MSIE 6.0")) {
                return MSIE_6_0;
            }
            if (header.contains("MSIE 7.0")) {
                if (header.contains("Trident")) {
                    return MSIE_7_0_COMPAT;
                }
                return MSIE_7_0;
            }
            if (header.contains("MSIE 8.0")) {
                return MSIE_8_0;
            }
            if (header.contains("MSIE 9.0")) {
                return MSIE_9_0;
            }
            if (header.contains("MSIE 10.0")) {
                return MSIE_10_0;
            }
            return MSIE;
        }
        if (header.contains("AppleWebKit")) {
            return WEBKIT;
        }
        if (header.contains("Gecko")) {
            if (header.contains("rv:1.8")) {
                return GECKO_1_8;
            }
            if (header.contains("rv:1.9")) {
                return GECKO_1_9;
            }
            if (header.contains("rv:2.0")) {
                return GECKO_2_0;
            }
            if (header.contains("rv:5.0")) {
                return GECKO_5_0;
            }
            return GECKO;
        }
        if (header.contains("Presto")) {
            return PRESTO;
        }
        return DEFAULT;
    }

    @Deprecated
    public static UserAgent getInstanceForId(String id) {
        Deprecation.LOG.error("Getting the user agent from its id is no longer supported! id='" + id + "'");
        return DEFAULT;
    }

    @Deprecated
    public String toString() {
        return this.version != null ? this.name + '_' + this.version : this.name;
    }
}

