/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.ThemeResources;
import org.apache.myfaces.tobago.context.ThemeScript;
import org.apache.myfaces.tobago.context.ThemeStyle;
import org.apache.myfaces.tobago.internal.config.RendererConfig;
import org.apache.myfaces.tobago.internal.config.RenderersConfig;
import org.apache.myfaces.tobago.internal.config.RenderersConfigImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeImpl
implements Theme,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ThemeImpl.class);
    private String name;
    private String displayName;
    private String deprecatedName;
    private String resourcePath;
    private ThemeImpl fallback;
    private String fallbackName;
    private List<Theme> fallbackList;
    private RenderersConfigImpl renderersConfig;
    private ThemeResources productionResources;
    private ThemeResources resources;
    private String[] productionScripts;
    private String[] productionStyles;
    private String[] scripts;
    private String[] styles;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDeprecatedName() {
        return this.deprecatedName;
    }

    public void setDeprecatedName(String deprecatedName) {
        this.deprecatedName = deprecatedName;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public ThemeImpl getFallback() {
        return this.fallback;
    }

    public void setFallback(ThemeImpl fallback) {
        this.fallback = fallback;
    }

    public String getFallbackName() {
        return this.fallbackName;
    }

    public void setFallbackName(String fallbackName) {
        this.fallbackName = fallbackName;
    }

    @Override
    public List<Theme> getFallbackList() {
        return this.fallbackList;
    }

    public void resolveFallbacks() {
        this.fallbackList = new ArrayList<Theme>();
        for (ThemeImpl actual = this; actual != null; actual = actual.getFallback()) {
            this.fallbackList.add(actual);
        }
        this.fallbackList = Collections.unmodifiableList(this.fallbackList);
        if (LOG.isDebugEnabled()) {
            for (Theme theme : this.fallbackList) {
                LOG.debug("fallbackList: {}", (Object)theme.getName());
            }
        }
    }

    public void resolveRendererConfig(RenderersConfig rendererConfigFromTobagoConfig) {
        if (this.renderersConfig == null) {
            this.renderersConfig = new RenderersConfigImpl();
        }
        if (!this.renderersConfig.isMerged()) {
            ThemeImpl fallback = this.getFallback();
            if (fallback != null) {
                fallback.resolveRendererConfig(rendererConfigFromTobagoConfig);
                RenderersConfigImpl fallbackRenderersConfig = fallback.getRenderersConfigImpl();
                if (fallbackRenderersConfig != null) {
                    this.renderersConfig.merge(fallbackRenderersConfig, false);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("merge markupconfig from {} for {}", (Object)fallback.getName(), (Object)this.getName());
                    }
                }
            }
            if (rendererConfigFromTobagoConfig != null) {
                this.renderersConfig.merge(rendererConfigFromTobagoConfig, true);
            }
            this.renderersConfig.setMerged(true);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} {}", (Object)this.getName(), (Object)this.renderersConfig);
            }
        }
    }

    public void resolveResources() {
        ThemeImpl fallback = this.getFallback();
        if (fallback != null) {
            fallback.resolveResources();
            this.addResources(fallback.getProductionResources());
            this.addResources(fallback.getResources());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Theme: ");
        builder.append(this.name);
        if (this.renderersConfig != null) {
            builder.append("\n");
            for (RendererConfig config : this.renderersConfig.getRendererConfigs()) {
                builder.append(config);
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    public void setRenderersConfig(RenderersConfigImpl renderersConfig) {
        this.renderersConfig = renderersConfig;
    }

    @Override
    public RenderersConfig getRenderersConfig() {
        return this.renderersConfig;
    }

    RenderersConfigImpl getRenderersConfigImpl() {
        return this.renderersConfig;
    }

    public ThemeResources getResources() {
        return this.resources;
    }

    public ThemeResources getProductionResources() {
        return this.productionResources;
    }

    public void addResources(ThemeResources resources) {
        if (resources.isProduction()) {
            if (this.productionResources != null) {
                this.merge(this.productionResources, resources);
            } else {
                this.productionResources = resources.copy();
            }
        } else if (this.resources != null) {
            this.merge(this.resources, resources);
        } else {
            this.resources = resources.copy();
        }
    }

    public void init() {
        int i;
        if (this.productionResources != null) {
            this.productionScripts = new String[this.productionResources.getScriptList().size()];
            for (i = 0; i < this.productionResources.getScriptList().size(); ++i) {
                this.productionScripts[i] = this.productionResources.getScriptList().get(i).getName();
            }
            this.productionStyles = new String[this.productionResources.getStyleList().size()];
            for (i = 0; i < this.productionResources.getStyleList().size(); ++i) {
                this.productionStyles[i] = this.productionResources.getStyleList().get(i).getName();
            }
        }
        if (this.resources != null) {
            this.scripts = new String[this.resources.getScriptList().size()];
            for (i = 0; i < this.resources.getScriptList().size(); ++i) {
                this.scripts[i] = this.resources.getScriptList().get(i).getName();
            }
            this.styles = new String[this.resources.getStyleList().size()];
            for (i = 0; i < this.resources.getStyleList().size(); ++i) {
                this.styles[i] = this.resources.getStyleList().get(i).getName();
            }
        }
    }

    private void merge(ThemeResources resources, ThemeResources toAddResources) {
        int i;
        if (resources == toAddResources) {
            return;
        }
        for (i = toAddResources.getScriptList().size() - 1; i >= 0; --i) {
            ThemeScript script = toAddResources.getScriptList().get(i);
            resources.getScriptList().remove(script);
            resources.getScriptList().add(0, script);
        }
        for (i = toAddResources.getStyleList().size() - 1; i >= 0; --i) {
            ThemeStyle style = toAddResources.getStyleList().get(i);
            resources.getStyleList().remove(style);
            resources.getStyleList().add(0, style);
        }
    }

    @Override
    public String[] getScriptResources(boolean production) {
        if (production) {
            return this.productionScripts;
        }
        return this.scripts;
    }

    @Override
    public String[] getStyleResources(boolean production) {
        if (production) {
            return this.productionStyles;
        }
        return this.styles;
    }
}

