/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.ObjectUtils;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.UserAgent;
import org.apache.myfaces.tobago.internal.context.ClientPropertiesKey;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.util.VariableResolverUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientProperties
implements Serializable {
    public static final String MANAGED_BEAN_NAME = "tobagoClientProperties";
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(ClientProperties.class);
    private String contentType = "html";
    private Theme theme;
    private UserAgent userAgent = UserAgent.DEFAULT;
    private boolean debugMode;
    private Locale locale;
    private Measure verticalScrollbarWeight;
    private Measure horizontalScrollbarWeight;
    private Measure pageWidth;
    private Measure pageHeight;

    public ClientProperties() {
        this(FacesContext.getCurrentInstance());
    }

    private ClientProperties(TobagoConfig tobagoConfig) {
        this.theme = tobagoConfig.getDefaultTheme();
        this.reset();
    }

    private ClientProperties(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        String accept = (String)externalContext.getRequestHeaderMap().get("Accept");
        if (accept != null && accept.indexOf("text/vnd.wap.wml") > -1) {
            this.contentType = "wml";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("contentType='" + this.contentType + "' from header " + "Accept='" + accept + "'");
        }
        String requestUserAgent = (String)externalContext.getRequestHeaderMap().get("User-Agent");
        this.userAgent = UserAgent.getInstance(requestUserAgent);
        if (LOG.isDebugEnabled()) {
            LOG.debug("userAgent='" + this.userAgent + "' from header " + "'User-Agent: " + requestUserAgent + "'");
        }
        String requestTheme = (String)externalContext.getRequestParameterMap().get("tobago.theme");
        TobagoConfig config = TobagoConfig.getInstance(facesContext);
        this.theme = config.getTheme(requestTheme);
        if (LOG.isDebugEnabled()) {
            LOG.debug("theme='" + this.theme.getName() + "' from requestParameter " + "tobago.theme='" + requestTheme + "'");
        }
        this.reset();
    }

    @Deprecated
    public static ClientProperties getDefaultInstance(FacesContext facesContext) {
        return new ClientProperties(TobagoConfig.getInstance(facesContext));
    }

    @Deprecated
    public static ClientProperties getInstance(UIViewRoot viewRoot) {
        return ClientProperties.getInstance(FacesContext.getCurrentInstance());
    }

    @Deprecated
    public static ClientProperties getInstance(FacesContext facesContext) {
        return VariableResolverUtils.resolveClientProperties(facesContext);
    }

    @Deprecated
    public static List<String> getLocaleList(Locale locale, boolean propertyPathMode) {
        int underscore;
        String string = locale.toString();
        String prefix = propertyPathMode ? "" : "_";
        ArrayList<String> locales = new ArrayList<String>(4);
        locales.add(prefix + string);
        while ((underscore = string.lastIndexOf(95)) > 0) {
            string = string.substring(0, underscore);
            locales.add(prefix + string);
        }
        locales.add(propertyPathMode ? "default" : "");
        return locales;
    }

    private void reset() {
        ClientPropertiesKey.reset(FacesContext.getCurrentInstance());
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        this.reset();
    }

    public Theme getTheme() {
        return this.theme;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
        this.reset();
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(UserAgent userAgent) {
        this.userAgent = userAgent;
        this.reset();
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (!ObjectUtils.equals((Object)this.locale, (Object)locale)) {
            this.locale = locale;
            this.reset();
        }
    }

    public Measure getVerticalScrollbarWeight() {
        return this.verticalScrollbarWeight;
    }

    public void setVerticalScrollbarWeight(Measure verticalScrollbarWeight) {
        this.verticalScrollbarWeight = verticalScrollbarWeight;
    }

    public Measure getHorizontalScrollbarWeight() {
        return this.horizontalScrollbarWeight;
    }

    public void setHorizontalScrollbarWeight(Measure horizontalScrollbarWeight) {
        this.horizontalScrollbarWeight = horizontalScrollbarWeight;
    }

    public Measure getPageWidth() {
        return this.pageWidth;
    }

    public void setPageWidth(Measure pageWidth) {
        this.pageWidth = pageWidth;
    }

    public Measure getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(Measure pageHeight) {
        this.pageHeight = pageHeight;
    }

    public void updateUserAgent(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        String requestUserAgent = (String)externalContext.getRequestHeaderMap().get("User-Agent");
        UserAgent newUserAgent = UserAgent.getInstance(requestUserAgent);
        if (newUserAgent != this.userAgent) {
            this.userAgent = newUserAgent;
            this.reset();
        }
    }
}

