/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.ajax;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.tobago.internal.ajax.AjaxInternalUtils;
import org.apache.myfaces.tobago.internal.util.ResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AjaxUtils.class);

    public static boolean isAjaxRequest(FacesContext facesContext) {
        Map parameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String ajaxComponentIds = (String)parameterMap.get("tobago::partialIds");
        return ajaxComponentIds != null;
    }

    public static void removeAjaxComponent(FacesContext facesContext, String clientId) {
        Map<String, UIComponent> ajaxComponents = AjaxInternalUtils.getAjaxComponents(facesContext);
        if (ajaxComponents != null) {
            ajaxComponents.remove(clientId);
        }
    }

    public static void addAjaxComponent(FacesContext facesContext, String clientId) {
        AjaxUtils.addAjaxComponent(facesContext, facesContext.getViewRoot().findComponent(clientId));
    }

    public static void addAjaxComponent(FacesContext facesContext, UIComponent component) {
        if (component == null) {
            LOG.warn("Ignore AjaxComponent: null");
            return;
        }
        Map<String, UIComponent> ajaxComponents = AjaxInternalUtils.getAjaxComponents(facesContext);
        if (ajaxComponents != null) {
            ajaxComponents.put(component.getClientId(facesContext), component);
        }
    }

    public static Set<String> getRequestPartialIds(FacesContext facesContext) {
        Map parameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String ajaxComponentIds = (String)parameterMap.get("tobago::partialIds");
        if (ajaxComponentIds != null) {
            StringTokenizer tokenizer = new StringTokenizer(ajaxComponentIds, ",");
            HashSet<String> ajaxComponents = new HashSet<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                String ajaxId = tokenizer.nextToken();
                ajaxComponents.add(ajaxId);
            }
            return ajaxComponents;
        }
        return Collections.EMPTY_SET;
    }

    public static boolean addUIMessagesToRenderedPartially(FacesContext context) {
        if (!AjaxUtils.isAjaxRequest(context)) {
            return false;
        }
        List<String> list = AjaxInternalUtils.getMessagesComponentIds(context);
        Iterator clientIds = context.getClientIdsWithMessages();
        boolean added = false;
        if (clientIds.hasNext()) {
            for (String componentClientId : list) {
                added = AjaxInternalUtils.addNextPossibleAjaxComponent(context, componentClientId);
            }
        } else {
            for (String componentClientId : list) {
                if (!context.getExternalContext().getRequestParameterMap().containsKey(componentClientId + "::" + "messagesExists")) continue;
                added = AjaxInternalUtils.addNextPossibleAjaxComponent(context, componentClientId);
            }
        }
        return added;
    }

    public static boolean redirect(FacesContext facesContext, String url) throws IOException {
        if (!AjaxUtils.isAjaxRequest(facesContext)) {
            return false;
        }
        HttpServletResponse httpServletResponse = (HttpServletResponse)facesContext.getExternalContext().getResponse();
        PrintWriter writer = httpServletResponse.getWriter();
        String contentType = "application/json; charset=UTF-8";
        ResponseUtils.ensureContentTypeHeader(facesContext, contentType);
        ResponseUtils.ensureNoCacheHeader(facesContext);
        AjaxUtils.redirectInternal(writer, url);
        ((Writer)writer).close();
        facesContext.responseComplete();
        return true;
    }

    private static void redirectInternal(Writer writer, String url) throws IOException {
        writer.flush();
        writer.write("{\n  \"tobagoAjaxResponse\": true,\n");
        writer.write("  \"responseCode\": 302,\n");
        writer.write("  \"location\": \"");
        writer.write(url);
        writer.write("\"\n}\n");
        writer.flush();
    }

    public static void redirect(HttpServletResponse response, String url) throws IOException {
        PrintWriter writer = response.getWriter();
        String contentType = "application/json; charset=UTF-8";
        ResponseUtils.ensureContentTypeHeader(response, contentType);
        ResponseUtils.ensureNoCacheHeader(response);
        AjaxUtils.redirectInternal(writer, url);
    }
}

