/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.UITree;
import org.apache.myfaces.tobago.component.UITreeData;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceUtils;
import org.apache.myfaces.tobago.event.TreeExpansionEvent;
import org.apache.myfaces.tobago.event.TreeMarkedEvent;
import org.apache.myfaces.tobago.internal.component.AbstractUITree;
import org.apache.myfaces.tobago.layout.Display;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.model.TreeSelectable;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeNodeRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TreeNodeRenderer.class);
    protected static final String OPEN_FOLDER = ResourceUtils.createString((String)"image", (String)"treeNode", (String)"icon", (String)"open", (String)"gif");
    protected static final String CLOSED_FOLDER = ResourceUtils.createString((String)"image", (String)"treeNode", (String)"icon", (String)"gif");
    protected static final String LEAF = ResourceUtils.createString((String)"image", (String)"treeNode", (String)"icon", (String)"leaf", (String)"gif");

    public void decode(FacesContext facesContext, UIComponent component) {
        String marked;
        String searchString;
        String selected;
        UITreeNode node = (UITreeNode)component;
        super.decode(facesContext, (UIComponent)node);
        if (ComponentUtils.isOutputOnly((UIComponent)node)) {
            return;
        }
        AbstractUITree tree = (AbstractUITree)ComponentUtils.findAncestor((UIComponent)node, AbstractUITree.class);
        String treeId = tree.getClientId(facesContext);
        String nodeStateId = node.nodeStateId(facesContext);
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String id = node.getClientId(facesContext);
        boolean folder = node.isFolder();
        boolean expanded = Boolean.parseBoolean((String)requestParameterMap.get(id + "::" + "expanded"));
        if (node.isExpanded() != expanded) {
            new TreeExpansionEvent((UIComponent)node, node.isExpanded(), expanded).queue();
        }
        if (tree.getSelectableAsEnum() == TreeSelectable.OFF || StringUtils.contains((String)(selected = (String)requestParameterMap.get(treeId + "-selectState")), (String)(searchString = ";" + nodeStateId + ";"))) {
            // empty if block
        }
        if ((marked = (String)requestParameterMap.get(treeId + "::" + "marked")) != null) {
            searchString = treeId + ':' + nodeStateId;
            boolean markedValue = marked.equals(searchString);
            if (node.isMarked() != markedValue) {
                new TreeMarkedEvent((UIComponent)node, node.isMarked(), markedValue).queue();
            }
        } else {
            LOG.warn("This log message is help clarifying the occurrence of this else case.");
        }
    }

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        super.prepareRender(facesContext, component);
        UITreeNode node = (UITreeNode)component;
        if (node.isMarked()) {
            node.setCurrentMarkup(Markup.MARKED.add(node.getCurrentMarkup()));
        }
        if (node.isFolder()) {
            node.setCurrentMarkup(Markup.FOLDER.add(node.getCurrentMarkup()));
            if (node.isExpanded()) {
                node.setCurrentMarkup(Markup.EXPANDED.add(node.getCurrentMarkup()));
            }
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeNode node = (UITreeNode)component;
        AbstractUITree tree = (AbstractUITree)ComponentUtils.findAncestor((UIComponent)node, AbstractUITree.class);
        boolean folder = node.isFolder();
        String id = node.getClientId(facesContext);
        int level = node.getLevel();
        boolean root = level == 0;
        boolean showRoot = ((UITree)tree).isShowRoot();
        boolean expanded = folder && node.isExpanded() || !showRoot && root;
        String clientId = node.getClientId(facesContext);
        int colon2 = clientId.lastIndexOf(":");
        int colon1 = clientId.substring(0, colon2 - 1).lastIndexOf(":");
        String structure = clientId.substring(colon1 + 1, colon2);
        String parentStructure = this.getParentStructure(structure);
        String parentId = root ? null : clientId.substring(0, colon1 + 1) + parentStructure + clientId.substring(colon2);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        if (expanded) {
            tree.getExpandedCache().add(structure);
        }
        if (showRoot || !root) {
            Style style;
            writer.startElement("div", null);
            writer.writeIdAttribute(id);
            if (!folder) {
                HtmlRendererUtils.renderDojoDndItem((UIComponent)node, (TobagoResponseWriter)writer, (boolean)true);
            }
            writer.writeClassAttribute(Classes.create((UIComponent)node));
            writer.writeAttribute("data-tobago-treeparent", parentId, false);
            HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)node);
            if (!root) {
                while (parentStructure != null) {
                    if (!tree.getExpandedCache().contains(parentStructure)) {
                        style = new Style();
                        style.setDisplay(Display.NONE);
                        writer.writeStyleAttribute(style);
                        break;
                    }
                    parentStructure = this.getParentStructure(parentStructure);
                }
            }
            String widthString = (style = new Style(facesContext, (LayoutBase)tree)).getWidth() != null ? "width: " + Integer.toString(style.getWidth().getPixel() - 22) : "100%";
            writer.writeStyleAttribute(widthString);
            if (folder) {
                this.encodeExpandedHidden(writer, node, id, expanded);
            }
            for (UIComponent child : node.getChildren()) {
                if (child instanceof UITreeNode || child instanceof UITreeData) continue;
                RenderUtils.encode((FacesContext)facesContext, (UIComponent)child);
            }
            writer.endElement("div");
        }
    }

    private String getParentStructure(String structure) {
        int underscore = structure.lastIndexOf("_");
        return underscore <= 0 ? null : structure.substring(0, underscore);
    }

    private void encodeExpandedHidden(TobagoResponseWriter writer, UITreeNode node, String clientId, boolean expanded) throws IOException {
        writer.startElement("input", (UIComponent)node);
        writer.writeAttribute("type", "hidden", false);
        writer.writeClassAttribute(Classes.create((UIComponent)node, (String)"expanded", (Markup)Markup.NULL));
        writer.writeNameAttribute(clientId + "::" + "expanded");
        writer.writeAttribute("value", Boolean.toString(expanded), false);
        writer.endElement("input");
    }
}

