/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.UITreeLabel;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.event.TreeExpansionEvent;
import org.apache.myfaces.tobago.event.TreeMarkedEvent;
import org.apache.myfaces.tobago.internal.component.AbstractUITree;
import org.apache.myfaces.tobago.internal.context.ResponseWriterDivider;
import org.apache.myfaces.tobago.layout.Display;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.model.TreeSelectable;
import org.apache.myfaces.tobago.renderkit.CommandRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag.TreeListboxRenderer;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeListboxNodeRenderer
extends CommandRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TreeListboxNodeRenderer.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        String marked;
        String searchString;
        String selected;
        UITreeNode node = (UITreeNode)component;
        super.decode(facesContext, (UIComponent)node);
        if (ComponentUtils.isOutputOnly((UIComponent)node)) {
            return;
        }
        AbstractUITree tree = (AbstractUITree)ComponentUtils.findAncestor((UIComponent)node, AbstractUITree.class);
        String treeId = tree.getClientId(facesContext);
        String nodeStateId = node.nodeStateId(facesContext);
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String id = node.getClientId(facesContext);
        boolean folder = node.isFolder();
        if (folder) {
            boolean expanded = Boolean.parseBoolean((String)requestParameterMap.get(id + "-expanded"));
            if (node.isExpanded() != expanded) {
                new TreeExpansionEvent((UIComponent)node, node.isExpanded(), expanded).queue();
            }
        }
        if (tree.getSelectableAsEnum() == TreeSelectable.OFF || StringUtils.contains((String)(selected = (String)requestParameterMap.get(treeId + "-selectState")), (String)(searchString = ";" + nodeStateId + ";"))) {
            // empty if block
        }
        if ((marked = (String)requestParameterMap.get(treeId + "::" + "marked")) != null) {
            searchString = treeId + ':' + nodeStateId;
            boolean markedValue = marked.equals(searchString);
            if (node.isMarked() != markedValue) {
                new TreeMarkedEvent((UIComponent)node, node.isMarked(), markedValue).queue();
            }
        } else {
            LOG.warn("This log message is help clarifying the occurrence of this else case.");
        }
    }

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        super.prepareRender(facesContext, component);
        UITreeNode node = (UITreeNode)component;
        if (node.isMarked()) {
            node.setMarkup(Markup.MARKED.add(node.getMarkup()));
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeNode node = (UITreeNode)component;
        AbstractUITree tree = (AbstractUITree)ComponentUtils.findAncestor((UIComponent)node, AbstractUITree.class);
        boolean folder = node.isFolder();
        int level = node.getLevel();
        String id = node.getClientId(facesContext);
        boolean expanded = folder && node.isExpanded();
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        if (level > 0) {
            writer.startElement("option", null);
            writer.writeIdAttribute(id);
            writer.writeAttribute("selected", expanded);
            writer.writeText("(" + level + ") " + this.getLabel(node));
            if (folder) {
                writer.writeText(" \u2192");
            }
            writer.endElement("option");
        }
        if (folder) {
            boolean siblingMode = "siblingLeafOnly".equals(tree.getAttributes().get("selectable"));
            ResponseWriterDivider divider = ResponseWriterDivider.getInstance((FacesContext)facesContext, (String)TreeListboxRenderer.DIVIDER);
            boolean alreadyExists = divider.activateBranch(facesContext);
            writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
            if (!alreadyExists) {
                writer.startElement("div", null);
                writer.writeClassAttribute(Classes.create((UIComponent)tree, (String)"level"));
                Style levelStyle = new Style();
                levelStyle.setLeft(Measure.valueOf((int)(level * 160)));
                writer.writeStyleAttribute(levelStyle);
                if (level > 0) {
                    writer.startElement("select", null);
                    writer.writeAttribute("disabled", true);
                    writer.writeAttribute("size", 2);
                    writer.writeClassAttribute(Classes.create((UIComponent)tree, (String)"select"));
                    writer.endElement("select");
                }
            }
            writer.startElement("select", (UIComponent)node);
            writer.writeIdAttribute(id + "::" + "select");
            writer.writeClassAttribute(Classes.create((UIComponent)tree, (String)"select"));
            if (!expanded) {
                Style selectStyle = new Style();
                selectStyle.setDisplay(Display.NONE);
            }
            writer.writeAttribute("size", 2);
            writer.writeAttribute("multiple", siblingMode);
            writer.startElement("optgroup", null);
            writer.writeAttribute("label", this.getLabel(node), true);
            writer.endElement("optgroup");
        }
    }

    private String getLabel(UITreeNode node) {
        for (UIComponent component : node.getChildren()) {
            if (!(component instanceof UITreeLabel)) continue;
            return "" + ((UITreeLabel)component).getValue();
        }
        return null;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeNode node = (UITreeNode)component;
        boolean folder = node.isFolder();
        if (folder) {
            TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
            writer.endElement("select");
            ResponseWriterDivider divider = ResponseWriterDivider.getInstance((FacesContext)facesContext, (String)TreeListboxRenderer.DIVIDER);
            divider.passivateBranch(facesContext);
        }
    }
}

