/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeIcon;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.context.ResourceUtils;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class TreeIconRenderer
extends LayoutComponentRendererBase {
    protected static final String OPEN_FOLDER = ResourceUtils.createString((String)"image", (String)"treeNode", (String)"icon", (String)"open", (String)"gif");
    protected static final String CLOSED_FOLDER = ResourceUtils.createString((String)"image", (String)"treeNode", (String)"icon", (String)"gif");
    protected static final String LEAF = ResourceUtils.createString((String)"image", (String)"treeNode", (String)"icon", (String)"leaf", (String)"gif");

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        String source;
        String openSource;
        UITreeIcon image = (UITreeIcon)component;
        UITreeNode node = (UITreeNode)ComponentUtils.findAncestor((UIComponent)image, UITreeNode.class);
        boolean folder = node.isFolder();
        boolean expanded = folder && node.isExpanded();
        String imageUrl = (String)image.getValue();
        String closedSource = imageUrl != null ? ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)imageUrl) : ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)CLOSED_FOLDER);
        if (folder) {
            openSource = imageUrl != null ? ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)ResourceUtils.addPostfixToFilename((String)imageUrl, (String)"-open"), (boolean)true) : ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)OPEN_FOLDER);
            source = expanded ? openSource : closedSource;
        } else {
            openSource = null;
            source = imageUrl != null ? ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)ResourceUtils.addPostfixToFilename((String)imageUrl, (String)"-leaf"), (boolean)true) : ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)LEAF);
        }
        if (source == null) {
            source = closedSource;
        }
        if (source == null) {
            source = openSource;
        }
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("img", null);
        writer.writeClassAttribute(Classes.create((UIComponent)node, (String)"toggle", (Markup)Markup.NULL));
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)image);
        writer.writeAttribute("src", source, true);
        if (folder) {
            writer.writeAttribute("data-tobago-srcopen", openSource, true);
            writer.writeAttribute("data-tobago-srcclose", closedSource, true);
        }
        writer.writeAttribute("alt", "", false);
        writer.endElement("img");
    }
}

