/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.component.UITreeCommand;
import org.apache.myfaces.tobago.component.UITreeNode;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.component.AbstractUICommandBase;
import org.apache.myfaces.tobago.internal.util.AccessKeyMap;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.CommandRendererBase;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.CommandRendererHelper;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeCommandRenderer
extends CommandRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TreeCommandRenderer.class);

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeCommand command = (UITreeCommand)component;
        UITreeNode node = (UITreeNode)ComponentUtils.findAncestor((UIComponent)command, UITreeNode.class);
        if (node.isDisabled()) {
            command.setDisabled(true);
        }
        super.prepareRender(facesContext, component);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UITreeCommand command = (UITreeCommand)component;
        String clientId = command.getClientId(facesContext);
        CommandRendererHelper helper = new CommandRendererHelper(facesContext, (AbstractUICommandBase)command, CommandRendererHelper.Tag.ANCHOR);
        String href = helper.getHref();
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)command);
        if (helper.isDisabled()) {
            writer.startElement("span", (UIComponent)command);
        } else {
            writer.startElement("a", (UIComponent)command);
            writer.writeAttribute("href", href, true);
            if (helper.getOnclick() != null) {
                writer.writeAttribute("onclick", helper.getOnclick(), true);
            }
            if (helper.getTarget() != null) {
                writer.writeAttribute("target", helper.getTarget(), true);
            }
            writer.writeNameAttribute(clientId);
        }
        writer.writeStyleAttribute(this.createStyle(facesContext, (AbstractUICommand)command));
        writer.writeClassAttribute(Classes.create((UIComponent)command));
        writer.writeIdAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)command);
        HtmlRendererUtils.renderTip((UIComponent)command, (TobagoResponseWriter)writer);
        writer.flush();
        if (label.getText() != null) {
            HtmlRendererUtils.writeLabelWithAccessKey((TobagoResponseWriter)writer, (LabelWithAccessKey)label);
        }
        if (label.getAccessKey() != null) {
            if (LOG.isInfoEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey())) {
                LOG.info("duplicated accessKey : " + label.getAccessKey());
            }
            HtmlRendererUtils.addClickAcceleratorKey((FacesContext)facesContext, (String)clientId, (char)label.getAccessKey().charValue());
        }
    }

    protected Style createStyle(FacesContext facesContext, AbstractUICommand link) {
        return new Style(facesContext, (LayoutBase)link);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (ComponentUtils.getBooleanAttribute((UIComponent)component, (String)"disabled")) {
            writer.endElement("span");
        } else {
            writer.endElement("a");
        }
    }
}

