/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import org.apache.myfaces.tobago.component.UITime;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.util.DateFormatUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.InputRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeRenderer
extends InputRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TimeRenderer.class);

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        String pattern;
        Converter converter;
        if (!(component instanceof UITime)) {
            LOG.error("Wrong type: Need " + UITime.class.getName() + ", but was " + component.getClass().getName());
            return;
        }
        UITime time = (UITime)component;
        String title = HtmlRendererUtils.getTitleFromTipAndMessages((FacesContext)facesContext, (UIComponent)time);
        String currentValue = this.getCurrentValue(facesContext, (UIComponent)time);
        if (LOG.isDebugEnabled()) {
            LOG.debug("currentValue = '" + currentValue + "'");
        }
        String converterPattern = "HH:mm";
        if (time.getConverter() != null && (converter = time.getConverter()) instanceof DateTimeConverter && (pattern = DateFormatUtils.findPattern((DateTimeConverter)((DateTimeConverter)converter))) != null && pattern.indexOf(115) > -1) {
            converterPattern = converterPattern + ":ss";
        }
        boolean hasSeconds = converterPattern.indexOf(115) > -1;
        Object value = time.getValue();
        Date date = value instanceof Date ? (Date)value : (value instanceof Calendar ? ((Calendar)value).getTime() : new Date());
        String hour = new SimpleDateFormat("HH").format(date);
        String minute = new SimpleDateFormat("mm").format(date);
        String second = new SimpleDateFormat("ss").format(date);
        String id = time.getClientId(facesContext);
        String idPrefix = id + "::";
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("div", (UIComponent)time);
        writer.writeClassAttribute(Classes.create((UIComponent)time));
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)time);
        Style style = new Style(facesContext, (LayoutBase)time);
        writer.writeStyleAttribute(style);
        writer.startElement("div", (UIComponent)time);
        writer.writeAttribute("id", idPrefix + "borderDiv", false);
        Markup markup = time.getCurrentMarkup();
        if (hasSeconds) {
            markup = markup.add(Markup.SECONDS);
        }
        writer.writeClassAttribute(Classes.create((UIComponent)time, (String)"borderDiv", (Markup)markup));
        this.writeInput(writer, time, idPrefix + "hour", hour, true, title);
        this.writeInputSeparator(writer, time, ":");
        this.writeInput(writer, time, idPrefix + "minute", minute, false, title);
        if (hasSeconds) {
            this.writeInputSeparator(writer, time, ":");
            this.writeInput(writer, time, idPrefix + "second", second, false, title);
        }
        writer.endElement("div");
        String imageId = idPrefix + "inc";
        String imageSrc = "image/timeIncrement.gif";
        writer.startElement("img", null);
        writer.writeIdAttribute(imageId);
        writer.writeClassAttribute(Classes.create((UIComponent)time, (String)"incImage", (Markup)markup));
        writer.writeAttribute("src", ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)imageSrc), true);
        writer.writeAttribute("alt", "", false);
        if (!ComponentUtils.getBooleanAttribute((UIComponent)time, (String)"disabled") && !ComponentUtils.getBooleanAttribute((UIComponent)time, (String)"readonly")) {
            writer.writeAttribute("onclick", "tbgIncTime(this)", false);
        }
        writer.endElement("img");
        imageId = idPrefix + "dec";
        imageSrc = "image/timeDecrement.gif";
        writer.startElement("img", null);
        writer.writeIdAttribute(imageId);
        writer.writeClassAttribute(Classes.create((UIComponent)time, (String)"decImage", (Markup)markup));
        writer.writeAttribute("src", ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)imageSrc), true);
        writer.writeAttribute("alt", "", false);
        if (!ComponentUtils.getBooleanAttribute((UIComponent)time, (String)"disabled") && !ComponentUtils.getBooleanAttribute((UIComponent)time, (String)"readonly")) {
            writer.writeAttribute("onclick", "tbgDecTime(this)", false);
        }
        writer.endElement("img");
        writer.startElement("input", (UIComponent)time);
        writer.writeAttribute("type", "hidden", false);
        writer.writeIdAttribute(id + ":converterPattern");
        writer.writeAttribute("value", converterPattern, true);
        writer.endElement("input");
        writer.startElement("input", (UIComponent)time);
        writer.writeAttribute("type", "hidden", false);
        writer.writeIdAttribute(id);
        writer.writeNameAttribute(id);
        writer.writeAttribute("value", hour + ":" + minute + ":" + second, false);
        writer.endElement("input");
        String dateTextBoxId = (String)time.getAttributes().get("dateInputId");
        if (dateTextBoxId != null) {
            String[] cmds = new String[]{"tbgInitTimeParse('" + id + "', '" + dateTextBoxId + "');"};
            HtmlRendererUtils.writeScriptLoader((FacesContext)facesContext, null, (String[])cmds);
        }
        writer.endElement("div");
    }

    private void writeInputSeparator(TobagoResponseWriter writer, UITime time, String sep) throws IOException {
        writer.startElement("span", null);
        writer.writeClassAttribute(Classes.create((UIComponent)time, (String)"sep"));
        writer.writeText(sep);
        writer.endElement("span");
    }

    private void writeInput(TobagoResponseWriter writer, UITime input, String id, String hour, boolean hourMode, String title) throws IOException {
        Integer tabIndex = input.getTabIndex();
        writer.startElement("input", null);
        writer.writeAttribute("type", "text", false);
        writer.writeIdAttribute(id);
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        writer.writeAttribute("title", title, true);
        writer.writeClassAttribute(Classes.create((UIComponent)input, (String)"input"));
        writer.writeAttribute("readonly", ComponentUtils.getBooleanAttribute((UIComponent)input, (String)"readonly"));
        writer.writeAttribute("disabled", ComponentUtils.getBooleanAttribute((UIComponent)input, (String)"disabled"));
        if (!ComponentUtils.getBooleanAttribute((UIComponent)input, (String)"disabled") && !ComponentUtils.getBooleanAttribute((UIComponent)input, (String)"readonly")) {
            writer.writeAttribute("onfocus", "tbgTimerInputFocus(this, " + hourMode + ")", false);
            writer.writeAttribute("onblur", "tbgTimerInputBlur(this)", false);
            writer.writeAttribute("onkeyup", "tbgTimerKeyUp(this, event)", false);
        }
        writer.writeAttribute("value", hour, true);
        writer.endElement("input");
    }
}

