/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.Validator;
import org.apache.myfaces.tobago.component.UITextarea;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.HtmlUtils;
import org.apache.myfaces.tobago.renderkit.InputRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextareaRenderer
extends InputRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(TextareaRenderer.class);

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        String currentValue;
        if (!(component instanceof UITextarea)) {
            LOG.error("Wrong type: Need " + UITextarea.class.getName() + ", but was " + component.getClass().getName());
            return;
        }
        UITextarea input = (UITextarea)component;
        String title = HtmlRendererUtils.getTitleFromTipAndMessages((FacesContext)facesContext, (UIComponent)component);
        String clientId = input.getClientId(facesContext);
        String onchange = HtmlUtils.generateOnchange((UIInput)input, (FacesContext)facesContext);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("textarea", (UIComponent)input);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)input);
        writer.writeAttribute("rows", null, "rows");
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        writer.writeAttribute("readonly", input.isReadonly());
        writer.writeAttribute("disabled", input.isDisabled());
        Integer tabIndex = input.getTabIndex();
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        HtmlRendererUtils.renderDojoDndItem((UIComponent)component, (TobagoResponseWriter)writer, (boolean)true);
        writer.writeClassAttribute(Classes.create((UIComponent)input));
        Style style = new Style(facesContext, (LayoutBase)input);
        writer.writeStyleAttribute(style);
        if (onchange != null) {
            writer.writeAttribute("onchange", (Object)onchange, null);
        }
        if ((currentValue = RenderUtils.currentValue((UIComponent)input)) != null) {
            if (currentValue.startsWith("\r\n")) {
                currentValue = "\r\n" + currentValue;
            } else if (currentValue.startsWith("\n")) {
                currentValue = "\n" + currentValue;
            } else if (currentValue.startsWith("\r")) {
                currentValue = "\r" + currentValue;
            }
            writer.writeText(currentValue);
        }
        writer.endElement("textarea");
        HtmlRendererUtils.checkForCommandFacet((UIComponent)input, (FacesContext)facesContext, (TobagoResponseWriter)writer);
        int maxLength = -1;
        for (Validator validator : input.getValidators()) {
            if (!(validator instanceof LengthValidator)) continue;
            LengthValidator lengthValidator = (LengthValidator)validator;
            maxLength = lengthValidator.getMaximum();
        }
        boolean required = ComponentUtils.getBooleanAttribute((UIComponent)input, (String)"required");
        if (required || maxLength > 0) {
            String[] cmds = new String[]{"new Tobago.In(\"" + input.getClientId(facesContext) + "\"," + required + ",\"" + Classes.requiredWorkaround((UIComponent)input) + "\" " + (maxLength > -1 ? "," + maxLength : "") + "  );"};
            HtmlRendererUtils.writeScriptLoader((FacesContext)facesContext, null, (String[])cmds);
        }
        HtmlRendererUtils.renderFocusId((FacesContext)facesContext, (UIInput)input);
    }
}

