/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.SupportsRenderedPartially;
import org.apache.myfaces.tobago.component.UIColumnEvent;
import org.apache.myfaces.tobago.component.UIColumnSelector;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UILink;
import org.apache.myfaces.tobago.component.UIMenu;
import org.apache.myfaces.tobago.component.UIMenuCommand;
import org.apache.myfaces.tobago.component.UIOut;
import org.apache.myfaces.tobago.component.UIReload;
import org.apache.myfaces.tobago.component.UISheet;
import org.apache.myfaces.tobago.component.UIToolBar;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManager;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.event.PageAction;
import org.apache.myfaces.tobago.internal.component.AbstractUIMenu;
import org.apache.myfaces.tobago.internal.context.ResourceManagerFactory;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.TextAlign;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Position;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.CreateComponentUtils;
import org.apache.myfaces.tobago.util.FacetUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(SheetRenderer.class);
    public static final String WIDTHS_POSTFIX = "::widths";
    public static final String SCROLL_POSTFIX = "::scrollPosition";
    public static final String SELECTED_POSTFIX = "::selected";
    private static final Integer HEIGHT_0 = 0;

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        UISheet sheet = (UISheet)uiComponent;
        Style style = new Style(facesContext, (LayoutBase)sheet);
        String sheetId = sheet.getClientId(facesContext);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("div", (UIComponent)sheet);
        writer.writeIdAttribute(sheetId);
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)sheet);
        String css = Classes.create((UIComponent)sheet).getStringValue() + " " + Classes.create((UIComponent)sheet, (String)"outer").getStringValue();
        writer.writeClassAttribute(css);
        writer.writeStyleAttribute(style);
        UICommand clickAction = null;
        UICommand dblClickAction = null;
        int columnSelectorIndex = -1;
        int i = 0;
        for (UIComponent child : sheet.getChildren()) {
            if (child instanceof UIColumnEvent) {
                UIComponent selectionChild;
                UIColumnEvent columnEvent = (UIColumnEvent)child;
                if (columnEvent.isRendered() && (selectionChild = (UIComponent)child.getChildren().get(0)) != null && selectionChild instanceof UICommand && selectionChild.isRendered()) {
                    UICommand action = (UICommand)selectionChild;
                    if ("click".equals(columnEvent.getEvent())) {
                        clickAction = action;
                    }
                    if ("dblclick".equals(columnEvent.getEvent())) {
                        dblClickAction = action;
                    }
                }
            } else if (child instanceof UIColumnSelector) {
                columnSelectorIndex = i;
            }
            ++i;
        }
        this.renderSheet(facesContext, sheet, clickAction != null || dblClickAction != null, style);
        writer.endElement("div");
        if (!FacesContextUtils.isAjax((FacesContext)facesContext) || !sheetId.equals(FacesContextUtils.getAjaxComponentId((FacesContext)facesContext))) {
            Integer frequency = null;
            UIComponent facetReload = sheet.getFacet("reload");
            if (facetReload != null && facetReload instanceof UIReload && facetReload.isRendered()) {
                UIReload update = (UIReload)facetReload;
                frequency = update.getFrequency();
            }
            String[] cmds = new String[]{"new Tobago.Sheet('" + sheetId + "', " + sheet.getFirst() + ", '" + sheet.getSelectable() + "', " + columnSelectorIndex + ", " + frequency + ", " + (clickAction != null ? HtmlRendererUtils.getJavascriptString((String)clickAction.getId()) : null) + ", " + HtmlRendererUtils.getRenderedPartiallyJavascriptArray((FacesContext)facesContext, (UICommand)clickAction) + ", " + (dblClickAction != null ? HtmlRendererUtils.getJavascriptString((String)dblClickAction.getId()) : null) + ", " + HtmlRendererUtils.getRenderedPartiallyJavascriptArray((FacesContext)facesContext, (UICommand)dblClickAction) + ", " + HtmlRendererUtils.getRenderedPartiallyJavascriptArray((FacesContext)facesContext, (UIComponent)sheet, (SupportsRenderedPartially)sheet) + ");"};
            HtmlRendererUtils.writeScriptLoader((FacesContext)facesContext, null, (String[])cmds);
        }
    }

    private void renderSheet(FacesContext facesContext, UISheet sheet, boolean hasClickAction, Style style) throws IOException {
        boolean showHeader;
        Measure sheetHeight;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        ResourceManager resourceManager = ResourceManagerFactory.getResourceManager((FacesContext)facesContext);
        String contextPath = facesContext.getExternalContext().getRequestContextPath();
        String sheetId = sheet.getClientId(facesContext);
        if (style.getHeight() == null) {
            LOG.error("no height in parent container, setting to 100");
            sheetHeight = Measure.valueOf((int)100);
        } else {
            sheetHeight = style.getHeight();
        }
        Measure footerHeight = this.getFooterHeight(facesContext, sheet);
        Measure headerHeight = this.getHeaderHeight(facesContext, sheet);
        String selectable = sheet.getSelectable();
        Application application = facesContext.getApplication();
        SheetState state = sheet.getSheetState(facesContext);
        List columnWidths = sheet.getWidthList();
        List<Integer> selectedRows = this.getSelectedRows(sheet, state);
        List renderedColumnList = sheet.getRenderedColumns();
        writer.startElement("input", null);
        writer.writeIdAttribute(sheetId + WIDTHS_POSTFIX);
        writer.writeNameAttribute(sheetId + WIDTHS_POSTFIX);
        writer.writeAttribute("type", "hidden", false);
        writer.writeAttribute("value", org.apache.myfaces.tobago.internal.util.StringUtils.joinWithSurroundingSeparator((List)columnWidths), false);
        writer.endElement("input");
        writer.startElement("input", null);
        writer.writeIdAttribute(sheetId + SCROLL_POSTFIX);
        writer.writeNameAttribute(sheetId + SCROLL_POSTFIX);
        writer.writeAttribute("type", "hidden", false);
        Integer[] scrollPosition = sheet.getScrollPosition();
        if (scrollPosition != null) {
            String scroll = scrollPosition[0] + ";" + scrollPosition[1];
            writer.writeAttribute("value", scroll, false);
        } else {
            writer.writeAttribute("value", "", false);
        }
        writer.endElement("input");
        if (!"none".equals(selectable)) {
            writer.startElement("input", null);
            writer.writeIdAttribute(sheetId + SELECTED_POSTFIX);
            writer.writeNameAttribute(sheetId + SELECTED_POSTFIX);
            writer.writeAttribute("type", "hidden", false);
            writer.writeAttribute("value", org.apache.myfaces.tobago.internal.util.StringUtils.joinWithSurroundingSeparator(selectedRows), true);
            writer.endElement("input");
        }
        boolean ie6SelectOneFix = (showHeader = sheet.isShowHeader()) && ClientProperties.getInstance((FacesContext)facesContext).getUserAgent().isMsie6() && ComponentUtils.findDescendant((UIComponent)sheet, UISelectOne.class) != null;
        Style bodyStyle = new Style();
        bodyStyle.setPosition(Position.RELATIVE);
        Measure tableBodyWidth = sheet.getCurrentWidth().subtractNotNegative(this.getContentBorder(facesContext, sheet));
        bodyStyle.setWidth(tableBodyWidth);
        if (sheet.isPagingVisible()) {
            sheetHeight = sheetHeight.subtract(footerHeight);
        }
        if (ie6SelectOneFix) {
            bodyStyle.setTop(headerHeight);
        }
        if (showHeader) {
            sheetHeight = sheetHeight.subtract(headerHeight);
        }
        bodyStyle.setHeight(sheetHeight);
        writer.startElement("div", null);
        writer.writeIdAttribute(sheetId + "::" + "data_div");
        writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"body"));
        if (!showHeader || ie6SelectOneFix) {
            bodyStyle.setPaddingTop(Measure.ZERO);
        }
        writer.writeStyleAttribute(bodyStyle);
        bodyStyle.setHeight(null);
        bodyStyle.setTop(null);
        Style sheetBodyStyle = new Style(bodyStyle);
        if (sheet.getNeedVerticalScrollbar() == Boolean.TRUE) {
            tableBodyWidth = tableBodyWidth.subtractNotNegative(this.getVerticalScrollbarWeight(facesContext, (Configurable)sheet));
        }
        sheetBodyStyle.setWidth(tableBodyWidth);
        writer.startElement("table", null);
        writer.writeAttribute("cellspacing", 0);
        writer.writeAttribute("cellpadding", 0);
        writer.writeAttribute("summary", "", false);
        writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"bodyTable"));
        writer.writeStyleAttribute(sheetBodyStyle);
        if (columnWidths != null) {
            writer.startElement("colgroup", null);
            for (Integer columnWidth : columnWidths) {
                writer.startElement("col", null);
                writer.writeAttribute("width", columnWidth.intValue());
                writer.endElement("col");
            }
            writer.endElement("colgroup");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("first = " + sheet.getFirst() + "   rows = " + sheet.getRows());
        }
        String var = sheet.getVar();
        boolean odd = false;
        boolean emptySheet = true;
        int last = sheet.isRowsUnlimited() ? Integer.MAX_VALUE : sheet.getFirst() + sheet.getRows();
        for (int rowIndex = sheet.getFirst(); rowIndex < last; ++rowIndex) {
            sheet.setRowIndex(rowIndex);
            if (!sheet.isRowAvailable()) break;
            emptySheet = false;
            boolean bl = odd = !odd;
            if (LOG.isDebugEnabled()) {
                LOG.debug("var       " + var);
                LOG.debug("list      " + sheet.getValue());
            }
            writer.startElement("tr", null);
            Markup rowMarkup = odd ? Markup.ODD : Markup.EVEN;
            boolean selected = selectedRows.contains(rowIndex);
            if (selected) {
                rowMarkup = rowMarkup.add(Markup.SELECTED);
            }
            writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"row", (Markup)rowMarkup));
            if (rowIndex == sheet.getFirst()) {
                writer.writeAttribute("rowIndexInModel", Integer.toString(sheet.getFirst()), false);
            }
            int columnIndex = -1;
            for (UIColumn column : renderedColumnList) {
                Markup markup;
                ++columnIndex;
                writer.startElement("td", (UIComponent)column);
                Markup markup2 = markup = column instanceof SupportsMarkup ? ((SupportsMarkup)column).getMarkup() : Markup.NULL;
                if (markup == null) {
                    markup = Markup.NULL;
                }
                if (columnIndex == 0) {
                    markup = markup.add(Markup.FIRST);
                }
                if (hasClickAction) {
                    markup = markup.add(Markup.CLICKABLE);
                }
                if (this.isPure(column)) {
                    markup = markup.add(Markup.PURE);
                }
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"cell", (Markup)markup));
                TextAlign align = TextAlign.parse((String)((String)column.getAttributes().get("align")));
                if (align != null) {
                    Style alignStyle = new Style();
                    alignStyle.setTextAlign(align);
                    writer.writeStyleAttribute(alignStyle);
                }
                if (column instanceof UIColumnSelector) {
                    boolean disabled = ComponentUtils.getBooleanAttribute((UIComponent)column, (String)"disabled");
                    writer.startElement("input", null);
                    writer.writeAttribute("type", "checkbox", false);
                    writer.writeAttribute("checked", selected);
                    writer.writeAttribute("disabled", disabled);
                    writer.writeIdAttribute(sheetId + "_data_row_selector_" + rowIndex);
                    writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"columnSelector"));
                    writer.endElement("input");
                } else {
                    List children = sheet.getRenderedChildrenOf(column);
                    for (UIComponent grandKid : children) {
                        grandKid.getAttributes().put("layoutHeight", HEIGHT_0);
                        if (grandKid instanceof LayoutBase) {
                            LayoutBase base = (LayoutBase)grandKid;
                            if (base.getLeft() != null) {
                                base.setLeft(null);
                            }
                            if (base.getTop() != null) {
                                base.setTop(null);
                            }
                        }
                        RenderUtils.prepareRendererAll((FacesContext)facesContext, (UIComponent)grandKid);
                        RenderUtils.encode((FacesContext)facesContext, (UIComponent)grandKid);
                    }
                }
                writer.endElement("td");
            }
            writer.startElement("td", null);
            writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"cell", (Markup)Markup.FILLER));
            writer.startElement("div", null);
            writer.endElement("div");
            writer.endElement("td");
            writer.endElement("tr");
        }
        sheet.setRowIndex(-1);
        if (emptySheet && showHeader) {
            writer.startElement("tr", null);
            int columnIndex = -1;
            for (UIColumn column : renderedColumnList) {
                writer.startElement("td", null);
                writer.startElement("div", null);
                Integer divWidth = (Integer)sheet.getWidthList().get(++columnIndex);
                Style divStyle = new Style();
                divStyle.setWidth(Measure.valueOf((Integer)divWidth));
                writer.writeStyleAttribute(divStyle);
                writer.endElement("div");
                writer.endElement("td");
            }
            writer.startElement("td", null);
            writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"cell", (Markup)Markup.FILLER));
            writer.startElement("div", null);
            writer.endElement("div");
            writer.endElement("td");
            writer.endElement("tr");
        }
        writer.endElement("table");
        writer.endElement("div");
        if (showHeader) {
            this.renderColumnHeaders(facesContext, sheet, writer, resourceManager, contextPath, sheetId, renderedColumnList, tableBodyWidth);
        }
        if (sheet.isPagingVisible()) {
            Markup showPageRange;
            Markup showDirectLinks;
            Style footerStyle = new Style();
            footerStyle.setWidth(sheet.getCurrentWidth());
            if (ie6SelectOneFix) {
                footerStyle.setTop(headerHeight);
            }
            writer.startElement("div", (UIComponent)sheet);
            writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"footer"));
            writer.writeStyleAttribute(footerStyle);
            Markup showRowRange = this.markupForLeftCenterRight(sheet.getShowRowRange());
            if (showRowRange != Markup.NULL) {
                UICommand pagerCommand = (UICommand)sheet.getFacet("pagerRow");
                if (pagerCommand == null) {
                    pagerCommand = this.createPagingCommand(application, PageAction.TO_ROW, false);
                    sheet.getFacets().put("pagerRow", pagerCommand);
                }
                String pagerCommandId = pagerCommand.getClientId(facesContext);
                writer.startElement("span", null);
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"pagingOuter", (Markup)showRowRange));
                writer.writeAttribute("title", ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetPagingInfoRowPagingTip"), true);
                writer.flush();
                writer.write(this.createSheetPagingInfo(sheet, facesContext, pagerCommandId, true));
                writer.endElement("span");
            }
            if ((showDirectLinks = this.markupForLeftCenterRight(sheet.getShowDirectLinks())) != Markup.NULL) {
                writer.startElement("span", null);
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"pagingOuter", (Markup)showDirectLinks));
                writer.writeIdAttribute(sheetId + "::" + "pagingLinks");
                this.writeDirectPagingLinks(writer, facesContext, application, sheet);
                writer.endElement("span");
            }
            if ((showPageRange = this.markupForLeftCenterRight(sheet.getShowPageRange())) != Markup.NULL) {
                UICommand pagerCommand = (UICommand)sheet.getFacet("pagerPage");
                if (pagerCommand == null) {
                    pagerCommand = this.createPagingCommand(application, PageAction.TO_PAGE, false);
                    sheet.getFacets().put("pagerPage", pagerCommand);
                }
                String pagerCommandId = pagerCommand.getClientId(facesContext);
                writer.startElement("span", null);
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"pagingOuter", (Markup)showPageRange));
                writer.writeIdAttribute(sheetId + "::" + "pagingPages");
                writer.writeText("");
                boolean atBeginning = sheet.isAtBeginning();
                this.link(facesContext, application, atBeginning, PageAction.FIRST, sheet);
                this.link(facesContext, application, atBeginning, PageAction.PREV, sheet);
                writer.startElement("span", null);
                writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"pagingText"));
                writer.writeAttribute("title", ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetPagingInfoPagePagingTip"), true);
                writer.flush();
                writer.write(this.createSheetPagingInfo(sheet, facesContext, pagerCommandId, false));
                writer.endElement("span");
                boolean atEnd = sheet.isAtEnd();
                this.link(facesContext, application, atEnd, PageAction.NEXT, sheet);
                this.link(facesContext, application, atEnd || !sheet.hasRowCount(), PageAction.LAST, sheet);
                writer.endElement("span");
            }
            writer.endElement("div");
        }
    }

    private boolean isPure(UIColumn column) {
        for (UIComponent child : column.getChildren()) {
            if (child instanceof UIOut || child instanceof UILink) continue;
            return true;
        }
        return false;
    }

    private String createSheetPagingInfo(UISheet sheet, FacesContext facesContext, String pagerCommandId, boolean row) {
        String sheetPagingInfo;
        if (sheet.getRowCount() != 0) {
            int first;
            Locale locale = facesContext.getViewRoot().getLocale();
            int n = first = row ? sheet.getFirst() + 1 : sheet.getCurrentPage() + 1;
            int last = sheet.hasRowCount() ? (row ? sheet.getLastRowIndexOfCurrentPage() : sheet.getPages()) : -1;
            boolean unknown = !sheet.hasRowCount();
            String key = "sheetPagingInfo" + (unknown ? "Undefined" : "") + (first == last ? "Single" : "") + (row ? "Row" : "Page") + (first == last ? "" : "s");
            String message = ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)key);
            MessageFormat detail = new MessageFormat(message, locale);
            Object[] args = new Object[]{first, last == -1 ? "?" : Integer.valueOf(last), unknown ? "" : Integer.valueOf(sheet.getRowCount()), pagerCommandId + "::" + "text"};
            sheetPagingInfo = detail.format(args);
        } else {
            sheetPagingInfo = ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)("sheetPagingInfoEmpty" + (row ? "Row" : "Page")));
        }
        return sheetPagingInfo;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        Integer[] scrollPosition;
        String value;
        String widths;
        super.decode(facesContext, component);
        String key = component.getClientId(facesContext) + WIDTHS_POSTFIX;
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(key) && (widths = (String)requestParameterMap.get(key)).trim().length() > 0) {
            component.getAttributes().put("widthListString", widths);
        }
        if (requestParameterMap.containsKey(key = component.getClientId(facesContext) + SELECTED_POSTFIX)) {
            List selectedRows;
            String selected = (String)requestParameterMap.get(key);
            if (LOG.isDebugEnabled()) {
                LOG.debug("selected = " + selected);
            }
            try {
                selectedRows = org.apache.myfaces.tobago.internal.util.StringUtils.parseIntegerList((String)selected);
            }
            catch (NumberFormatException e) {
                LOG.warn(selected, (Throwable)e);
                selectedRows = Collections.emptyList();
            }
            component.getAttributes().put("selectedListString", selectedRows);
        }
        if ((value = (String)requestParameterMap.get(key = component.getClientId(facesContext) + SCROLL_POSTFIX)) != null && (scrollPosition = SheetState.parseScrollPosition((String)value)) != null) {
            component.getAttributes().put("attrScrollPosition", scrollPosition);
        }
    }

    private Measure getHeaderHeight(FacesContext facesContext, UISheet sheet) {
        return sheet.isShowHeader() ? this.getResourceManager().getThemeMeasure(facesContext, (Configurable)sheet, "headerHeight") : Measure.ZERO;
    }

    private Measure getRowHeight(FacesContext facesContext, UISheet sheet) {
        return this.getResourceManager().getThemeMeasure(facesContext, (Configurable)sheet, "rowHeight");
    }

    private Measure getFooterHeight(FacesContext facesContext, UISheet sheet) {
        return sheet.isPagingVisible() ? this.getResourceManager().getThemeMeasure(facesContext, (Configurable)sheet, "footerHeight") : Measure.ZERO;
    }

    private Markup markupForLeftCenterRight(String name) {
        if ("left".equals(name)) {
            return Markup.LEFT;
        }
        if ("center".equals(name)) {
            return Markup.CENTER;
        }
        if ("right".equals(name)) {
            return Markup.RIGHT;
        }
        return Markup.NULL;
    }

    private String checkPagingAttribute(String name) {
        if (this.isNotNone(name)) {
            return name;
        }
        if (!"none".equals(name)) {
            LOG.warn("Illegal value in sheets paging attribute: '" + name + "'");
        }
        return "none";
    }

    private boolean isNotNone(String value) {
        return "left".equals(value) || "center".equals(value) || "right".equals(value);
    }

    public boolean getRendersChildren() {
        return true;
    }

    private List<Integer> getSelectedRows(UISheet data, SheetState state) {
        List selected = (List)data.getAttributes().get("selectedListString");
        if (selected == null && state != null) {
            selected = state.getSelectedRows();
        }
        if (selected == null) {
            selected = Collections.emptyList();
        }
        return selected;
    }

    private void link(FacesContext facesContext, Application application, boolean disabled, PageAction command, UISheet data) throws IOException {
        UICommand link = this.createPagingCommand(application, command, disabled);
        data.getFacets().put(command.getToken(), link);
        String tip = ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)("sheet" + command.getToken()));
        String image = ResourceManagerUtils.getImageWithPath((FacesContext)facesContext, (String)("image/sheet" + command.getToken() + (disabled ? "Disabled" : "") + ".gif"));
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("img", null);
        writer.writeIdAttribute(data.getClientId(facesContext) + "::" + "pagingPages" + "::" + command.getToken());
        Classes pagerClasses = Classes.create((UIComponent)data, (String)"footerPagerButton", (Markup)(disabled ? Markup.DISABLED : null));
        writer.writeClassAttribute(pagerClasses);
        writer.writeAttribute("src", image, false);
        writer.writeAttribute("title", tip, true);
        writer.writeAttribute("alt", "", false);
        writer.writeAttribute("data-tobago-disabled", disabled);
        writer.endElement("img");
    }

    private void renderColumnHeaders(FacesContext facesContext, UISheet sheet, TobagoResponseWriter writer, ResourceManager resourceManager, String contextPath, String sheetId, List<UIColumn> renderedColumnList, Measure headerWidth) throws IOException {
        writer.startElement("div", null);
        writer.writeIdAttribute(sheetId + "::" + "header_div");
        writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"headerDiv"));
        Style style = new Style();
        style.setWidth(headerWidth);
        writer.writeStyleAttribute(style);
        int columnCount = 0;
        for (UIColumn column : renderedColumnList) {
            this.renderColumnHeader(facesContext, writer, sheet, columnCount, column, resourceManager, contextPath);
            ++columnCount;
        }
        writer.startElement("span", null);
        writer.writeIdAttribute(sheetId + "::" + "header_box_filler");
        writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"header"));
        writer.writeStyleAttribute("width:0px");
        writer.endElement("span");
        writer.endElement("div");
    }

    private void renderColumnHeader(FacesContext facesContext, TobagoResponseWriter writer, UISheet sheet, int columnIndex, UIColumn column, ResourceManager resourceManager, String contextPath) throws IOException {
        AbstractUIMenu dropDownMenu;
        String sheetId = sheet.getClientId(facesContext);
        Application application = facesContext.getApplication();
        Integer divWidth = (Integer)sheet.getWidthList().get(columnIndex);
        Style divStyle = new Style();
        divWidth = divWidth - 6;
        divStyle.setWidth(Measure.valueOf((Integer)divWidth));
        TextAlign align = TextAlign.parse((String)((String)column.getAttributes().get("align")));
        divStyle.setTextAlign(align);
        writer.startElement("span", null);
        writer.writeIdAttribute(sheetId + "::" + "header_box_" + columnIndex);
        writer.writeStyleAttribute(divStyle);
        String tip = (String)column.getAttributes().get("tip");
        if (tip == null) {
            tip = "";
        }
        if ((dropDownMenu = FacetUtils.getDropDownMenu((UIComponent)column)) != null) {
            LOG.error("Drop down menu is not implemented in sheets yet!");
        }
        Markup markup = Markup.NULL;
        String sorterImage = null;
        boolean sortable = ComponentUtils.getBooleanAttribute((UIComponent)column, (String)"sortable");
        if (sortable && !(column instanceof UIColumnSelector)) {
            UICommand sortCommand = (UICommand)column.getFacet("sorter");
            if (sortCommand == null) {
                String columnId = column.getClientId(facesContext);
                String sorterId = columnId.substring(columnId.lastIndexOf(":") + 1) + "_" + "sorter";
                sortCommand = (UICommand)application.createComponent("org.apache.myfaces.tobago.Command");
                sortCommand.setRendererType("Link");
                sortCommand.setId(sorterId);
                column.getFacets().put("sorter", sortCommand);
            }
            writer.writeAttribute("sorterId", sortCommand.getClientId(facesContext), false);
            if (StringUtils.isNotEmpty((String)tip)) {
                tip = tip + " - ";
            }
            tip = tip + ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetTipSorting");
            markup = markup.add(Markup.SORTABLE);
            SheetState sheetState = sheet.getSheetState(facesContext);
            if (column.getId().equals(sheetState.getSortedColumnId())) {
                String sortTitle;
                if (sheetState.isAscending()) {
                    sorterImage = contextPath + resourceManager.getImage(facesContext, "image/ascending.gif");
                    sortTitle = ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetAscending");
                    markup = markup.add(Markup.ASCENDING);
                } else {
                    sorterImage = contextPath + resourceManager.getImage(facesContext, "image/descending.gif");
                    sortTitle = ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"sheetDescending");
                    markup = markup.add(Markup.DESCENDING);
                }
                if (sortTitle != null) {
                    tip = tip + " - " + sortTitle;
                }
            }
        }
        if (columnIndex == 0) {
            markup = markup.add(Markup.FIRST);
        }
        writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"header", (Markup)markup));
        writer.writeAttribute("title", tip, true);
        if (column instanceof UIColumnSelector) {
            this.renderColumnSelectorHeader(facesContext, writer, sheet, (UIColumnSelector)column);
        } else {
            String label = (String)column.getAttributes().get("label");
            if (label != null) {
                writer.startElement("span", null);
                writer.writeText(label);
                writer.endElement("span");
            }
        }
        if (sorterImage != null) {
            writer.startElement("img", null);
            writer.writeAttribute("src", sorterImage, false);
            writer.writeAttribute("alt", "", false);
            writer.endElement("img");
        }
        writer.endElement("span");
        if (ComponentUtils.getBooleanAttribute((UIComponent)column, (String)"resizable")) {
            writer.startElement("span", null);
            writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"headerSpacerOuter"));
            writer.startElement("span", null);
            writer.writeIdAttribute(sheetId + "::" + "header_spacer_" + columnIndex);
            Markup resizeMarkup = column instanceof UIColumnSelector ? Markup.NULL : Markup.RESIZABLE;
            writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"headerSpacer", (Markup)resizeMarkup));
            writer.write("&nbsp;&nbsp;");
            writer.endElement("span");
            writer.endElement("span");
        }
    }

    protected void renderColumnSelectorHeader(FacesContext facesContext, TobagoResponseWriter writer, UISheet sheet, UIColumnSelector column) throws IOException {
        UIToolBar toolBar = this.createToolBar(facesContext, sheet);
        writer.startElement("div", null);
        writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"toolBar"));
        if ("multi".equals(sheet.getSelectable())) {
            RenderUtils.prepareRendererAll((FacesContext)facesContext, (UIComponent)toolBar);
            RenderUtils.encode((FacesContext)facesContext, (UIComponent)toolBar);
        }
        writer.endElement("div");
    }

    private UIToolBar createToolBar(FacesContext facesContext, UISheet sheet) {
        Application application = facesContext.getApplication();
        UICommand dropDown = (UICommand)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Command", null, (String)"dropDown");
        UIMenu menu = (UIMenu)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Menu", (String)"Menu", (String)"menu");
        FacetUtils.setDropDownMenu((UIComponent)dropDown, (AbstractUIMenu)menu);
        String sheetId = sheet.getClientId(facesContext);
        this.createMenuItem(facesContext, menu, "sheetMenuSelect", Markup.SHEET_SELECT_ALL, sheetId);
        this.createMenuItem(facesContext, menu, "sheetMenuUnselect", Markup.SHEET_DESELECT_ALL, sheetId);
        this.createMenuItem(facesContext, menu, "sheetMenuToggleselect", Markup.SHEET_TOGGLE_ALL, sheetId);
        UIToolBar toolBar = (UIToolBar)application.createComponent("org.apache.myfaces.tobago.ToolBar");
        toolBar.setId(facesContext.getViewRoot().createUniqueId());
        toolBar.setRendererType("TabGroupToolBar");
        toolBar.setTransient(true);
        toolBar.getChildren().add(dropDown);
        sheet.getFacets().put("toolBar", toolBar);
        return toolBar;
    }

    private void createMenuItem(FacesContext facesContext, UIMenu menu, String label, Markup markup, String sheetId) {
        String id = markup.toString();
        UIMenuCommand menuItem = (UIMenuCommand)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.MenuCommand", (String)"MenuCommand", (String)id);
        menuItem.setLabel(ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)label));
        menuItem.setMarkup(markup);
        menuItem.setOnclick("/**/");
        ComponentUtils.putDataAttributeWithPrefix((UIComponent)menuItem, (String)"data-tobago-sheetid", (Object)sheetId);
        menu.getChildren().add(menuItem);
    }

    private void writeDirectPagingLinks(TobagoResponseWriter writer, FacesContext facesContext, Application application, UISheet sheet) throws IOException {
        int skip;
        UICommand pagerCommand = (UICommand)sheet.getFacet("pagerPage");
        if (pagerCommand == null) {
            pagerCommand = this.createPagingCommand(application, PageAction.TO_PAGE, false);
            sheet.getFacets().put("pagerPage", pagerCommand);
        }
        String pagerCommandId = pagerCommand.getClientId(facesContext);
        int linkCount = ComponentUtils.getIntAttribute((UIComponent)sheet, (String)"directLinkCount");
        ArrayList<Integer> prevs = new ArrayList<Integer>(--linkCount);
        int page = sheet.getCurrentPage() + 1;
        for (int i = 0; i < linkCount && page > 1; ++i) {
            if (--page <= 0) continue;
            prevs.add(0, page);
        }
        ArrayList<Integer> nexts = new ArrayList<Integer>(linkCount);
        page = sheet.getCurrentPage() + 1;
        int pages = sheet.hasRowCount() || sheet.isRowsUnlimited() ? sheet.getPages() : Integer.MAX_VALUE;
        for (int i = 0; i < linkCount && page < pages; ++i) {
            if (++page <= 1) continue;
            nexts.add(page);
        }
        if (prevs.size() > linkCount / 2 && nexts.size() > linkCount - linkCount / 2) {
            while (prevs.size() > linkCount / 2) {
                prevs.remove(0);
            }
            while (nexts.size() > linkCount - linkCount / 2) {
                nexts.remove(nexts.size() - 1);
            }
        } else if (prevs.size() <= linkCount / 2) {
            while (prevs.size() + nexts.size() > linkCount) {
                nexts.remove(nexts.size() - 1);
            }
        } else {
            while (prevs.size() + nexts.size() > linkCount) {
                prevs.remove(0);
            }
        }
        int n = skip = prevs.size() > 0 ? (Integer)prevs.get(0) : 1;
        if (skip > 1) {
            skip -= linkCount - linkCount / 2;
            String name = "...";
            if (--skip < 1) {
                skip = 1;
                if ((Integer)prevs.get(0) == 2) {
                    name = "1";
                }
            }
            this.writeLinkElement(writer, sheet, name, Integer.toString(skip), pagerCommandId, true);
        }
        for (Integer prev : prevs) {
            String name = prev.toString();
            this.writeLinkElement(writer, sheet, name, name, pagerCommandId, true);
        }
        String name = Integer.toString(sheet.getCurrentPage() + 1);
        this.writeLinkElement(writer, sheet, name, name, pagerCommandId, false);
        for (Integer next : nexts) {
            name = next.toString();
            this.writeLinkElement(writer, sheet, name, name, pagerCommandId, true);
        }
        int n2 = skip = nexts.size() > 0 ? (Integer)nexts.get(nexts.size() - 1) : pages;
        if (skip < pages) {
            skip += linkCount / 2;
            name = "...";
            if (++skip > pages) {
                skip = pages;
                if ((Integer)nexts.get(nexts.size() - 1) == skip - 1) {
                    name = Integer.toString(skip);
                }
            }
            this.writeLinkElement(writer, sheet, name, Integer.toString(skip), pagerCommandId, true);
        }
    }

    private UICommand createPagingCommand(Application application, PageAction command, boolean disabled) {
        UICommand link = (UICommand)application.createComponent("org.apache.myfaces.tobago.Command");
        link.setRendererType("SheetPageCommand");
        link.setRendered(true);
        link.setId(command.getToken());
        link.getAttributes().put("inline", Boolean.TRUE);
        link.getAttributes().put("disabled", disabled);
        return link;
    }

    private void writeLinkElement(TobagoResponseWriter writer, UISheet sheet, String str, String skip, String id, boolean makeLink) throws IOException {
        String type = makeLink ? "a" : "span";
        writer.startElement(type, null);
        writer.writeClassAttribute(Classes.create((UIComponent)sheet, (String)"pagingLink"));
        if (makeLink) {
            writer.writeIdAttribute(id + "::" + "link_" + skip);
            writer.writeAttribute("href", "#", true);
        }
        writer.flush();
        writer.write(str);
        writer.endElement(type);
    }

    private Measure getContentBorder(FacesContext facesContext, UISheet data) {
        return this.getBorderLeft(facesContext, (Configurable)data).add(this.getBorderRight(facesContext, (Configurable)data));
    }

    public Measure getPreferredHeight(FacesContext facesContext, Configurable component) {
        UISheet sheet = (UISheet)component;
        Measure headerHeight = this.getHeaderHeight(facesContext, sheet);
        Measure rowHeight = this.getRowHeight(facesContext, sheet);
        Measure footerHeight = this.getFooterHeight(facesContext, sheet);
        int rows = sheet.getRows();
        if (rows == 0) {
            rows = sheet.getRowCount();
        }
        if (rows == -1) {
            rows = 10;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(headerHeight + " " + footerHeight + " " + rowHeight + " " + rows);
        }
        return headerHeight.add(rowHeight.multiply(rows)).add(footerHeight);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getPrepareRendersChildren() {
        return true;
    }

    public void prepareRendersChildren(FacesContext facesContext, UIComponent component) throws IOException {
        UISheet sheet = (UISheet)component;
        for (UIColumn column : sheet.getRenderedColumns()) {
            RenderUtils.prepareRendererAll((FacesContext)facesContext, (UIComponent)column);
        }
    }
}

