/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UISelectOneRadio;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.SelectOneRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectOneRadioRenderer
extends SelectOneRendererBase {
    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        UISelectOne select = (UISelectOne)component;
        super.prepareRender(facesContext, (UIComponent)select);
        FacesContextUtils.addOnloadScript((FacesContext)facesContext, (String)("Tobago.selectOneRadioInit('" + select.getClientId(facesContext) + "')"));
        if (select instanceof UISelectOneRadio && ((UISelectOneRadio)select).isInline()) {
            ComponentUtils.addCurrentMarkup((SupportsMarkup)((UISelectOneRadio)select), (Markup)Markup.INLINE);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UISelectOneRadio select = (UISelectOneRadio)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        String id = select.getClientId(facesContext);
        List items = RenderUtils.getItemsToRender((UISelectOne)select);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages((FacesContext)facesContext, (UIComponent)select);
        boolean disabled = select.isDisabled();
        boolean readonly = select.isReadonly();
        Style style = new Style(facesContext, (LayoutBase)select);
        boolean required = select.isRequired();
        style.setDisplay(null);
        writer.startElement("ol", (UIComponent)select);
        writer.writeIdAttribute(id);
        writer.writeStyleAttribute(style);
        writer.writeClassAttribute(Classes.create((UIComponent)select));
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)select);
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        Object value = select.getValue();
        ArrayList<String> clientIds = new ArrayList<String>();
        for (SelectItem item : items) {
            Integer tabIndex;
            String itemId = id + ':' + ':' + item.getValue().toString();
            clientIds.add(itemId);
            writer.startElement("li", (UIComponent)select);
            writer.startElement("input", (UIComponent)select);
            writer.writeAttribute("type", "radio", false);
            boolean checked = item.getValue().equals(value);
            writer.writeAttribute("checked", checked);
            writer.writeNameAttribute(id);
            writer.writeIdAttribute(itemId);
            String formattedValue = RenderUtils.getFormattedValue((FacesContext)facesContext, (UIComponent)select, (Object)item.getValue());
            writer.writeAttribute("value", formattedValue, true);
            writer.writeAttribute("disabled", item.isDisabled() || disabled);
            writer.writeAttribute("readonly", readonly);
            if (!required || readonly) {
                writer.writeAttribute("onclick", "Tobago.selectOneRadioClick(this, '" + id + "'," + required + " , " + readonly + ")", false);
            }
            if ((tabIndex = select.getTabIndex()) != null) {
                writer.writeAttribute("tabindex", tabIndex.intValue());
            }
            writer.endElement("input");
            String label = item.getLabel();
            if (label != null) {
                writer.startElement("label", (UIComponent)select);
                writer.writeAttribute("for", itemId, false);
                writer.writeText(label);
                writer.endElement("label");
            }
            writer.endElement("li");
        }
        writer.endElement("ol");
        HtmlRendererUtils.renderFocusId((FacesContext)facesContext, (UIInput)select);
        HtmlRendererUtils.checkForCommandFacet((UIComponent)select, clientIds, (FacesContext)facesContext, (TobagoResponseWriter)writer);
    }

    public Measure getHeight(FacesContext facesContext, Configurable component) {
        UISelectOneRadio select = (UISelectOneRadio)component;
        Measure heightOfOne = super.getHeight(facesContext, component);
        if (select.isInline()) {
            return heightOfOne;
        }
        List items = RenderUtils.getItemsToRender((UISelectOne)((UISelectOne)component));
        return heightOfOne.multiply(items.size());
    }
}

