/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UISelectOneListbox;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.SelectOneRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectOneListboxRenderer
extends SelectOneRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(SelectOneListboxRenderer.class);

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (!(component instanceof UISelectOneListbox)) {
            LOG.error("Wrong type: Need " + UISelectOneListbox.class.getName() + ", but was " + component.getClass().getName());
            return;
        }
        UISelectOneListbox select = (UISelectOneListbox)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        String id = select.getClientId(facesContext);
        List items = RenderUtils.getSelectItems((UIComponent)select);
        boolean disabled = items.size() == 0 || select.isDisabled() || select.isReadonly();
        writer.startElement("select", (UIComponent)select);
        writer.writeNameAttribute(id);
        writer.writeIdAttribute(id);
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)select);
        writer.writeAttribute("disabled", disabled);
        Integer tabIndex = select.getTabIndex();
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        Style style = new Style(facesContext, (LayoutBase)select);
        writer.writeStyleAttribute(style);
        writer.writeClassAttribute(Classes.create((UIComponent)select));
        HtmlRendererUtils.renderTip((UIComponent)select, (TobagoResponseWriter)writer);
        writer.writeAttribute("size", 2);
        if (!ComponentUtils.getBooleanAttribute((UIComponent)select, (String)"required")) {
            writer.writeAttribute("onchange", "Tobago.selectOneListboxChange(this)", false);
            writer.writeAttribute("onclick", "Tobago.selectOneListboxClick(this)", false);
        }
        Object[] values = new Object[]{select.getValue()};
        HtmlRendererUtils.renderSelectItems((UIInput)select, (List)items, (Object[])values, (TobagoResponseWriter)writer, (FacesContext)facesContext);
        writer.endElement("select");
        super.encodeEnd(facesContext, (UIComponent)select);
        HtmlRendererUtils.renderFocusId((FacesContext)facesContext, (UIInput)select);
        HtmlRendererUtils.checkForCommandFacet((UIComponent)select, (FacesContext)facesContext, (TobagoResponseWriter)writer);
    }
}

