/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UISelectManyCheckbox;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.SelectManyRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SelectManyCheckboxRenderer
extends SelectManyRendererBase {
    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        UISelectManyCheckbox select = (UISelectManyCheckbox)component;
        super.prepareRender(facesContext, (UIComponent)select);
        if (select.isInline()) {
            ComponentUtils.addCurrentMarkup((SupportsMarkup)select, (Markup)Markup.INLINE);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UISelectManyCheckbox select = (UISelectManyCheckbox)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        String id = select.getClientId(facesContext);
        List items = RenderUtils.getItemsToRender((UISelectMany)select);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages((FacesContext)facesContext, (UIComponent)select);
        boolean disabled = select.isDisabled();
        boolean readonly = select.isReadonly();
        Style style = new Style(facesContext, (LayoutBase)select);
        style.setDisplay(null);
        writer.startElement("ol", (UIComponent)select);
        writer.writeIdAttribute(id);
        writer.writeStyleAttribute(style);
        writer.writeClassAttribute(Classes.create((UIComponent)select));
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)select);
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        Object[] values = select.getSelectedValues();
        ArrayList<String> clientIds = new ArrayList<String>();
        for (SelectItem item : items) {
            Integer tabIndex;
            String itemId = id + ':' + ':' + item.getValue().toString();
            clientIds.add(itemId);
            writer.startElement("li", (UIComponent)select);
            writer.startElement("input", (UIComponent)select);
            writer.writeAttribute("type", "checkbox", false);
            boolean checked = RenderUtils.contains((Object[])values, (Object)item.getValue());
            writer.writeAttribute("checked", checked);
            writer.writeNameAttribute(id);
            writer.writeIdAttribute(itemId);
            String formattedValue = RenderUtils.getFormattedValue((FacesContext)facesContext, (UIComponent)select, (Object)item.getValue());
            writer.writeAttribute("value", formattedValue, true);
            writer.writeAttribute("disabled", item.isDisabled() || disabled);
            writer.writeAttribute("readonly", readonly);
            if (readonly) {
                writer.writeAttribute("onclick", "this.checked=" + checked, false);
            }
            if ((tabIndex = select.getTabIndex()) != null) {
                writer.writeAttribute("tabindex", tabIndex.intValue());
            }
            writer.endElement("input");
            String label = item.getLabel();
            if (label != null) {
                writer.startElement("label", (UIComponent)select);
                writer.writeAttribute("for", itemId, false);
                writer.writeText(label);
                writer.endElement("label");
            }
            writer.endElement("li");
        }
        writer.endElement("ol");
        HtmlRendererUtils.renderFocusId((FacesContext)facesContext, (UIInput)select);
        HtmlRendererUtils.checkForCommandFacet((UIComponent)select, clientIds, (FacesContext)facesContext, (TobagoResponseWriter)writer);
    }

    public Measure getHeight(FacesContext facesContext, Configurable component) {
        UISelectManyCheckbox select = (UISelectManyCheckbox)component;
        Measure heightOfOne = super.getHeight(facesContext, component);
        if (select.isInline()) {
            return heightOfOne;
        }
        List items = RenderUtils.getItemsToRender((UISelectMany)((UISelectMany)component));
        return heightOfOne.multiply(items.size());
    }
}

