/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.ajax.AjaxUtils;
import org.apache.myfaces.tobago.component.UICell;
import org.apache.myfaces.tobago.component.UICommand;
import org.apache.myfaces.tobago.component.UIMessages;
import org.apache.myfaces.tobago.component.UIPopup;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.ajax.AjaxInternalUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUIMessages;
import org.apache.myfaces.tobago.internal.component.AbstractUIPage;
import org.apache.myfaces.tobago.internal.component.AbstractUIPopup;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.CreateComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagesRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(MessagesRenderer.class);
    public static final String CLOSE_POPUP = "closePopup";

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        List messageList;
        UIMessages messages = (UIMessages)component;
        if (messages.isConfirmation()) {
            this.createPopup(facesContext, messages);
            return;
        }
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("facesContext is " + facesContext.getClass().getName());
        }
        if ((messageList = messages.createMessageList(facesContext)).size() > 0) {
            writer.startElement("span", (UIComponent)messages);
            writer.writeClassAttribute(Classes.create((UIComponent)messages));
            HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)messages);
            writer.writeStyleAttribute(new Style(facesContext, (LayoutBase)messages));
            for (AbstractUIMessages.Item item : messageList) {
                this.encodeMessage(writer, messages, item.getFacesMessage(), item.getClientId());
            }
            writer.endElement("span");
            if (messages.getFor() == null) {
                String clientId = messages.getClientId(facesContext);
                writer.startElement("input", null);
                writer.writeAttribute("value", Boolean.TRUE.toString(), false);
                writer.writeAttribute("id", clientId + "::" + "messagesExists", false);
                writer.writeAttribute("name", clientId + "::" + "messagesExists", false);
                writer.writeAttribute("type", "hidden", false);
                writer.endElement("input");
            }
        }
        if (messages.getFor() == null && !AjaxUtils.isAjaxRequest((FacesContext)facesContext)) {
            AjaxInternalUtils.storeMessagesClientIds((FacesContext)facesContext, (AbstractUIMessages)messages);
        }
    }

    private void createPopup(FacesContext facesContext, UIMessages messages) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("POPUP");
        }
        String id = messages.getId() != null ? messages.getId() + "popup" : facesContext.getViewRoot().createUniqueId();
        UIPopup popup = (UIPopup)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Popup", (String)"Popup", (String)id);
        popup.getAttributes().put("zIndex", 10);
        AbstractUIPage page = ComponentUtils.findPage((FacesContext)facesContext, (UIComponent)messages);
        popup.setWidth(page.getCurrentWidth().subtract(200));
        popup.setHeight(page.getCurrentHeight().subtract(200));
        popup.setLeft(Measure.valueOf((int)100));
        popup.setTop(Measure.valueOf((int)100));
        popup.setRendered(true);
        popup.setActivated(true);
        popup.onComponentPopulated(facesContext, (UIComponent)messages);
        FacesContextUtils.addPopup((FacesContext)facesContext, (AbstractUIPopup)popup);
        Map okButtonAttributes = popup.getAttributes();
        okButtonAttributes.put("popupReset", Boolean.TRUE);
        UIComponent box = CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Box", (String)"Box");
        popup.getChildren().add(box);
        box.setId("box");
        box.getAttributes().put("label", ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"tobago.message.confirmation.title"));
        UIComponent layout = CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.GridLayout", (String)"GridLayout", (String)"layout");
        box.getFacets().put("layout", layout);
        layout.getAttributes().put("rows", "*;auto");
        layout.getAttributes().put("margin", Measure.valueOf((int)10));
        UICell scrollPanel = (UICell)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Cell", (String)"Cell", (String)"messagePanel");
        box.getChildren().add(scrollPanel);
        messages.getParent().getChildren().remove(messages);
        messages.setConfirmation(false);
        scrollPanel.onComponentPopulated(facesContext, (UIComponent)messages);
        scrollPanel.setScrollbars("auto");
        scrollPanel.getChildren().add(messages);
        UIComponent buttonPanel = CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Panel", (String)"Panel", (String)"buttonPanel");
        layout = CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.GridLayout", (String)"GridLayout", (String)"buttonPanelLayout");
        buttonPanel.getFacets().put("layout", layout);
        layout.getAttributes().put("columns", "*;100px");
        layout.getAttributes().put("rows", "auto");
        box.getChildren().add(buttonPanel);
        UICell space = (UICell)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Cell", (String)"Cell", (String)"space");
        buttonPanel.getChildren().add(space);
        space.onComponentPopulated(facesContext, (UIComponent)messages);
        UICommand okButton = (UICommand)CreateComponentUtils.createComponent((FacesContext)facesContext, (String)"org.apache.myfaces.tobago.Button", (String)"Button", (String)CLOSE_POPUP);
        buttonPanel.getChildren().add(okButton);
        okButtonAttributes = okButton.getAttributes();
        okButtonAttributes.put("label", ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"tobago.message.confirmation.okay"));
        okButtonAttributes.put("popupClose", "immediate");
    }

    private void encodeMessage(TobagoResponseWriter writer, UIMessages messages, FacesMessage message, String clientId) throws IOException {
        String summary = message.getSummary();
        String detail = message.getDetail();
        writer.startElement("label", null);
        if (clientId != null) {
            writer.writeAttribute("for", clientId, false);
        }
        writer.writeAttribute("title", detail, true);
        Markup markup = ComponentUtils.markupOfSeverity((FacesMessage.Severity)message.getSeverity());
        writer.writeClassAttribute(Classes.create((UIComponent)messages, (String)"item", (Markup)markup));
        boolean writeEmptyText = true;
        if (summary != null && messages.isShowSummary()) {
            writer.writeText(summary);
            writeEmptyText = false;
            if (detail != null && messages.isShowDetail()) {
                writer.writeText(" ");
            }
        }
        if (detail != null && messages.isShowDetail()) {
            writeEmptyText = false;
            writer.writeText(detail);
        }
        if (writeEmptyText) {
            writer.writeText("");
        }
        writer.endElement("label");
        writer.startElement("br", null);
        writer.endElement("br");
    }

    public Measure getPreferredHeight(FacesContext facesContext, Configurable component) {
        Measure measure = super.getPreferredHeight(facesContext, component);
        UIMessages messages = (UIMessages)component;
        int count = messages.createMessageList(facesContext).size();
        return measure.multiply(count);
    }
}

