/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UIMenu;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.util.AccessKeyMap;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.LayoutComponentRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MenuRenderer
extends LayoutComponentRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(MenuRenderer.class);

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        boolean firstLevel;
        super.prepareRender(facesContext, component);
        UIMenu menu = (UIMenu)component;
        boolean bl = firstLevel = !"Menu".equals(menu.getParent().getRendererType());
        if (firstLevel) {
            ComponentUtils.addCurrentMarkup((SupportsMarkup)menu, (Markup)Markup.TOP);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        UIMenu menu = (UIMenu)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        boolean disabled = menu.isDisabled();
        boolean firstLevel = !"Menu".equals(menu.getParent().getRendererType());
        boolean isParentMenu = menu.getChildCount() > 0;
        String clientId = menu.getClientId(facesContext);
        writer.startElement("li", (UIComponent)menu);
        writer.writeClassAttribute(Classes.create((UIComponent)menu, (Markup)(firstLevel ? Markup.TOP : null)));
        writer.writeIdAttribute(clientId);
        if (menu.getImage() != null) {
            Style style = new Style();
            style.setBackgroundImage("url(" + menu.getImage() + ")");
            writer.writeStyleAttribute(style);
        }
        writer.startElement("a", (UIComponent)menu);
        writer.writeAttribute("href", "#", false);
        LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)menu);
        if (label.getText() != null) {
            if (label.getAccessKey() != null) {
                if (LOG.isInfoEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey())) {
                    LOG.info("duplicated accessKey : " + label.getAccessKey());
                }
                if (!disabled) {
                    HtmlRendererUtils.addAcceleratorKey((FacesContext)facesContext, (UIComponent)menu, (Character)label.getAccessKey());
                }
            }
            HtmlRendererUtils.writeLabelWithAccessKey((TobagoResponseWriter)writer, (LabelWithAccessKey)label);
        }
        writer.endElement("a");
        if (isParentMenu) {
            writer.startElement("ol", (UIComponent)menu);
            writer.writeIdAttribute(clientId + "::" + "menu");
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        boolean isParentMenu;
        UIMenu menu = (UIMenu)component;
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        boolean bl = isParentMenu = menu.getChildCount() > 0;
        if (isParentMenu) {
            writer.endElement("ol");
        }
        writer.endElement("li");
        Set accKeyFunctions = FacesContextUtils.getMenuAcceleratorScripts((FacesContext)facesContext);
        if (!accKeyFunctions.isEmpty()) {
            HtmlRendererUtils.writeScriptLoader((FacesContext)facesContext, null, (String[])accKeyFunctions.toArray(new String[accKeyFunctions.size()]));
            FacesContextUtils.clearMenuAcceleratorScripts((FacesContext)facesContext);
        }
    }
}

