/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUICommandBase;
import org.apache.myfaces.tobago.internal.component.AbstractUILink;
import org.apache.myfaces.tobago.internal.util.AccessKeyMap;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.PixelMeasure;
import org.apache.myfaces.tobago.renderkit.CommandRendererBase;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.CommandRendererHelper;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkRenderer
extends CommandRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(LinkRenderer.class);

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUILink link = (AbstractUILink)component;
        String clientId = link.getClientId(facesContext);
        CommandRendererHelper helper = new CommandRendererHelper(facesContext, (AbstractUICommandBase)link, CommandRendererHelper.Tag.ANCHOR);
        String href = helper.getHref();
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)link);
        if (helper.isDisabled()) {
            writer.startElement("span", (UIComponent)link);
        } else {
            Integer tabIndex;
            writer.startElement("a", (UIComponent)link);
            writer.writeAttribute("href", href, true);
            if (helper.getOnclick() != null) {
                writer.writeAttribute("onclick", helper.getOnclick(), true);
            }
            if (helper.getTarget() != null) {
                writer.writeAttribute("target", helper.getTarget(), true);
            }
            if ((tabIndex = link.getTabIndex()) != null) {
                writer.writeAttribute("tabindex", tabIndex.intValue());
            }
        }
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)link);
        Style style = new Style(facesContext, (LayoutBase)link);
        writer.writeStyleAttribute(style);
        HtmlRendererUtils.renderDojoDndItem((UIComponent)component, (TobagoResponseWriter)writer, (boolean)true);
        writer.writeClassAttribute(Classes.create((UIComponent)link));
        writer.writeIdAttribute(clientId);
        writer.writeNameAttribute(clientId);
        HtmlRendererUtils.renderTip((UIComponent)link, (TobagoResponseWriter)writer);
        writer.flush();
        String image = link.getImage();
        if (image != null) {
            if (!ResourceManagerUtils.isAbsoluteResource((String)image)) {
                image = this.getImageWithPath(facesContext, image, helper.isDisabled());
            }
            writer.startElement("img", (UIComponent)link);
            writer.writeClassAttribute(Classes.create((UIComponent)link, (String)"image"));
            writer.writeAttribute("src", image, true);
            writer.writeAttribute("border", 0);
            String tip = link.getTip();
            writer.writeAttribute("alt", tip != null ? tip : "", true);
            if (tip != null) {
                writer.writeAttribute("title", tip, true);
            }
            writer.endElement("img");
        }
        if (label.getText() != null) {
            if (image != null) {
                writer.write(" ");
            }
            HtmlRendererUtils.writeLabelWithAccessKey((TobagoResponseWriter)writer, (LabelWithAccessKey)label);
        }
        if (label.getAccessKey() != null) {
            if (LOG.isInfoEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey())) {
                LOG.info("duplicated accessKey : " + label.getAccessKey());
            }
            HtmlRendererUtils.addClickAcceleratorKey((FacesContext)facesContext, (String)clientId, (char)label.getAccessKey().charValue());
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUILink link = (AbstractUILink)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        if (link.isDisabled()) {
            writer.endElement("span");
        } else {
            writer.endElement("a");
        }
    }

    public Measure getPreferredWidth(FacesContext facesContext, Configurable component) {
        AbstractUILink link = (AbstractUILink)component;
        LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)link);
        String text = label.getText();
        String image = link.getImage();
        Measure width = PixelMeasure.ZERO;
        if (text != null) {
            Measure m = RenderUtils.calculateStringWidth((FacesContext)facesContext, (UIComponent)link, (String)text);
            width = width.add(m);
        }
        if (text != null && image != null) {
            width = width.add(4);
        }
        if (image != null) {
            width = width.add(16);
        }
        return width;
    }
}

