/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.Validator;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.tobago.component.UIIn;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUIInput;
import org.apache.myfaces.tobago.internal.component.AbstractUIPage;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.model.AutoSuggestExtensionItem;
import org.apache.myfaces.tobago.model.AutoSuggestItem;
import org.apache.myfaces.tobago.model.AutoSuggestItems;
import org.apache.myfaces.tobago.renderkit.InputRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InRenderer
extends InputRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(InRenderer.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        super.decode(facesContext, component);
        String clientId = component.getClientId(facesContext);
        AbstractUIPage page = ComponentUtils.findPage((UIComponent)component);
        if (clientId.equals(page.getActionId())) {
            facesContext.renderResponse();
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIPage page;
        if (!(component instanceof AbstractUIInput)) {
            LOG.error("Wrong type: Need " + AbstractUIInput.class.getName() + ", but was " + component.getClass().getName());
            return;
        }
        String clientId = component.getClientId(facesContext);
        if (clientId.equals((page = ComponentUtils.findPage((UIComponent)component)).getActionId())) {
            this.encodeAjax(facesContext, component);
        } else {
            AbstractUIInput input = (AbstractUIInput)component;
            String title = HtmlRendererUtils.getTitleFromTipAndMessages((FacesContext)facesContext, (UIComponent)input);
            String currentValue = this.getCurrentValue(facesContext, (UIComponent)input);
            boolean password = ComponentUtils.getBooleanAttribute((UIComponent)input, (String)"password");
            if (LOG.isDebugEnabled()) {
                LOG.debug("currentValue = '" + (password && currentValue != null ? StringUtils.leftPad((String)"", (int)currentValue.length(), (char)'*') : currentValue) + "'");
            }
            String type = password ? "password" : "text";
            boolean readonly = ComponentUtils.getBooleanAttribute((UIComponent)input, (String)"readonly");
            boolean disabled = ComponentUtils.getBooleanAttribute((UIComponent)input, (String)"disabled");
            boolean renderAjaxSuggest = false;
            if (input instanceof UIIn) {
                renderAjaxSuggest = ((UIIn)input).getSuggestMethod() != null;
            }
            String id = input.getClientId(facesContext);
            TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
            writer.startElement("input", (UIComponent)input);
            writer.writeAttribute("type", type, false);
            writer.writeNameAttribute(id);
            writer.writeIdAttribute(id);
            HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)input);
            if (currentValue != null) {
                writer.writeAttribute("value", currentValue, true);
            }
            if (title != null) {
                writer.writeAttribute("title", title, true);
            }
            int maxLength = 0;
            for (Validator validator : input.getValidators()) {
                if (!(validator instanceof LengthValidator)) continue;
                LengthValidator lengthValidator = (LengthValidator)validator;
                maxLength = lengthValidator.getMaximum();
            }
            if (maxLength > 0) {
                writer.writeAttribute("maxlength", maxLength);
            }
            writer.writeAttribute("readonly", readonly);
            writer.writeAttribute("disabled", disabled);
            Integer tabIndex = input.getTabIndex();
            if (tabIndex != null) {
                writer.writeAttribute("tabindex", tabIndex.intValue());
            }
            Style style = new Style(facesContext, (LayoutBase)input);
            writer.writeStyleAttribute(style);
            String placeholder = input.getPlaceholder();
            if (!disabled && !readonly && StringUtils.isNotBlank((String)placeholder)) {
                writer.writeAttribute("placeholder", placeholder, true);
            }
            HtmlRendererUtils.renderDojoDndItem((UIComponent)component, (TobagoResponseWriter)writer, (boolean)true);
            writer.writeClassAttribute(Classes.create((UIComponent)input));
            writer.endElement("input");
            HtmlRendererUtils.checkForCommandFacet((UIComponent)input, (FacesContext)facesContext, (TobagoResponseWriter)writer);
            boolean required = ComponentUtils.getBooleanAttribute((UIComponent)input, (String)"required");
            String requiredClass = Classes.requiredWorkaround((UIComponent)input);
            if (required && !renderAjaxSuggest) {
                String[] cmds = new String[]{"new Tobago.In(\"" + id + "\", true ,\"" + requiredClass + "\"  );"};
                HtmlRendererUtils.writeScriptLoader((FacesContext)facesContext, null, (String[])cmds);
            }
            HtmlRendererUtils.renderFocusId((FacesContext)facesContext, (UIInput)input);
            if (renderAjaxSuggest) {
                UIIn in = (UIIn)input;
                int suggestMinChars = in.getSuggestMinChars();
                int suggestDelay = in.getSuggestDelay();
                String[] cmds = new String[]{"new Tobago.AutocompleterAjax(", "    '" + id + "',", "    " + required + ",", "    '" + requiredClass + "',", "    {minPrefixLength:" + suggestMinChars + ",eventDelay:" + suggestDelay + "});"};
                HtmlRendererUtils.writeScriptLoader((FacesContext)facesContext, null, (String[])cmds);
            }
        }
    }

    private void encodeAjax(FacesContext facesContext, UIComponent component) throws IOException {
        if (!(component instanceof UIIn)) {
            LOG.error("Wrong type: Need " + UIIn.class.getName() + ", but was " + component.getClass().getName());
            return;
        }
        UIIn input = (UIIn)component;
        MethodBinding methodBinding = input.getSuggestMethod();
        AutoSuggestItems items = this.createAutoSuggestItems(methodBinding.invoke(facesContext, new Object[]{input}));
        List suggestItems = items.getItems();
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startJavascript();
        writer.write("Tobago.ajaxComponents['");
        writer.write(component.getClientId(facesContext));
        writer.write("'].suggestions = {items: [");
        for (int i = 0; i < suggestItems.size() && i < items.getMaxSuggestedCount(); ++i) {
            AutoSuggestItem suggestItem = (AutoSuggestItem)suggestItems.get(i);
            if (i > 0) {
                writer.write(", ");
            }
            writer.write("{label: '");
            String label = suggestItem.getLabel();
            label = StringUtils.replace((String)label, (String)"\\", (String)"\\\\");
            label = StringUtils.replace((String)label, (String)"\"", (String)"\\\"");
            writer.write(label);
            writer.write("', value: '");
            String value = suggestItem.getLabel();
            value = StringUtils.replace((String)value, (String)"\\", (String)"\\\\");
            value = StringUtils.replace((String)value, (String)"\"", (String)"\\\"");
            writer.write(value);
            writer.write("'");
            if (suggestItem.getExtensionItems() != null) {
                writer.write(", values: [");
                for (int j = 0; j < suggestItem.getExtensionItems().size(); ++j) {
                    AutoSuggestExtensionItem item = (AutoSuggestExtensionItem)suggestItem.getExtensionItems().get(j);
                    if (j > 0) {
                        writer.write(", ");
                    }
                    writer.write("{id: '");
                    writer.write(item.getId());
                    writer.write("', value: '");
                    writer.write(item.getValue());
                    writer.write("'}");
                }
                writer.write("]");
            }
            if (suggestItem.getNextFocusId() != null) {
                writer.write(", nextFocusId: '");
                writer.write(suggestItem.getNextFocusId());
                writer.write("'");
            }
            writer.write("}");
        }
        writer.write("]");
        if (items.getNextFocusId() != null) {
            writer.write(", nextFocusId: \"");
            writer.write(items.getNextFocusId());
            writer.write("\"");
        }
        if (suggestItems.size() > items.getMaxSuggestedCount()) {
            writer.write(", moreElements: \"");
            writer.write(ResourceManagerUtils.getPropertyNotNull((FacesContext)facesContext, (String)"tobago", (String)"tobago.in.inputSuggest.moreElements"));
            writer.write("\"");
        }
        writer.write("};");
        writer.endJavascript();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AutoSuggestItems createAutoSuggestItems(Object object) {
        if (object instanceof AutoSuggestItems) {
            return (AutoSuggestItems)object;
        }
        AutoSuggestItems autoSuggestItems = new AutoSuggestItems();
        if (object instanceof List && !((List)object).isEmpty()) {
            if (((List)object).get(0) instanceof AutoSuggestItem) {
                autoSuggestItems.setItems((List)object);
                return autoSuggestItems;
            } else {
                if (!(((List)object).get(0) instanceof String)) throw new ClassCastException("Cant create AutoSuggestItems from '" + object + "'. " + "Elements needs to be " + String.class.getName() + " or " + AutoSuggestItem.class.getName());
                ArrayList<AutoSuggestItem> items = new ArrayList<AutoSuggestItem>(((List)object).size());
                for (int i = 0; i < ((List)object).size(); ++i) {
                    AutoSuggestItem item = new AutoSuggestItem();
                    item.setLabel((String)((List)object).get(i));
                    item.setValue((String)((List)object).get(i));
                    items.add(item);
                }
                autoSuggestItems.setItems(items);
            }
            return autoSuggestItems;
        } else {
            autoSuggestItems.setItems(Collections.emptyList());
        }
        return autoSuggestItems;
    }
}

