/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.myfaces.tobago.component.UIFileInput;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.internal.webapp.TobagoMultipartFormdataRequest;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.InputRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRenderer
extends InputRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(FileRenderer.class);

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        super.prepareRender(facesContext, component);
        FacesContextUtils.setEnctype((FacesContext)facesContext, (String)"multipart/form-data");
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        ServletRequest wrappedRequest;
        if (!(component instanceof UIFileInput)) {
            LOG.error("Wrong type: Need " + UIFileInput.class.getName() + ", but was " + component.getClass().getName());
            return;
        }
        if (ComponentUtils.isOutputOnly((UIComponent)component)) {
            return;
        }
        UIFileInput input = (UIFileInput)component;
        TobagoMultipartFormdataRequest request = null;
        Object requestObject = facesContext.getExternalContext().getRequest();
        if (requestObject instanceof TobagoMultipartFormdataRequest) {
            request = (TobagoMultipartFormdataRequest)requestObject;
        } else if (requestObject instanceof HttpServletRequestWrapper && (wrappedRequest = ((HttpServletRequestWrapper)requestObject).getRequest()) instanceof TobagoMultipartFormdataRequest) {
            request = (TobagoMultipartFormdataRequest)wrappedRequest;
        }
        if (request == null) {
            LOG.error("Can't process multipart/form-data without TobagoRequest. Please check the web.xml and define a TobagoMultipartFormdataFilter. See documentation for <tc:file>");
        } else {
            FileItem item = request.getFileItem(input.getClientId(facesContext));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Uploaded file name : \"" + item.getName() + "\"  size = " + item.getSize());
            }
            input.setSubmittedValue((Object)item);
            input.setValid(true);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (!(component instanceof UIFileInput)) {
            LOG.error("Wrong type: Need " + UIFileInput.class.getName() + ", but was " + component.getClass().getName());
            return;
        }
        UIFileInput input = (UIFileInput)component;
        String clientId = input.getClientId(facesContext);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        writer.startElement("input", (UIComponent)input);
        writer.writeAttribute("type", "file", false);
        writer.writeClassAttribute(Classes.create((UIComponent)input));
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)input);
        Style style = new Style(facesContext, (LayoutBase)input);
        writer.writeStyleAttribute(style);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        writer.writeAttribute("readonly", ComponentUtils.getBooleanAttribute((UIComponent)input, (String)"disabled"));
        Integer tabIndex = input.getTabIndex();
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        HtmlRendererUtils.renderTip((UIComponent)input, (TobagoResponseWriter)writer);
        if (ClientProperties.getInstance((FacesContext)facesContext).getUserAgent().isMsie6()) {
            writer.writeAttribute("onkeydown", "this.blur();return false;", false);
            writer.writeAttribute("oncontextmenu", "return false;", false);
        }
        writer.endElement("input");
    }
}

