/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import org.apache.myfaces.tobago.internal.util.DateFormatUtils;
import org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag.InRenderer;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateRenderer
extends InRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(DateRenderer.class);

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeEnd(facesContext, component);
        Converter help = this.getConverter(facesContext, component);
        if (help instanceof DateTimeConverter) {
            DateTimeConverter converter = (DateTimeConverter)help;
            String pattern = DateFormatUtils.findPattern((DateTimeConverter)converter);
            if (pattern != null) {
                TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
                String id = component.getClientId(facesContext);
                writer.startElement("input", component);
                writer.writeAttribute("type", "hidden", false);
                writer.writeIdAttribute(id + ":converterPattern");
                writer.writeAttribute("value", pattern, false);
                writer.endElement("input");
            } else {
                LOG.warn("Can't find the pattern for the converter! DatePicker may not work correctly.");
            }
        }
    }
}

