/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.scarborough.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.SupportsMarkup;
import org.apache.myfaces.tobago.component.UIButton;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.ResourceManagerUtils;
import org.apache.myfaces.tobago.internal.component.AbstractUICommandBase;
import org.apache.myfaces.tobago.internal.util.AccessKeyMap;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.CommandRendererBase;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.CommandRendererHelper;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ButtonRenderer
extends CommandRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(ButtonRenderer.class);

    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        SupportsMarkup button = (SupportsMarkup)component;
        boolean defaultCommand = ComponentUtils.getBooleanAttribute((UIComponent)component, (String)"defaultCommand");
        super.prepareRender(facesContext, component);
        if (defaultCommand) {
            button.setCurrentMarkup(Markup.DEFAULT.add(button.getCurrentMarkup()));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UIButton button = (UIButton)component;
        String clientId = button.getClientId(facesContext);
        CommandRendererHelper helper = new CommandRendererHelper(facesContext, (AbstractUICommandBase)button, CommandRendererHelper.Tag.BUTTON);
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)button);
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("type", this.createButtonType((UIComponent)button), false);
        writer.writeNameAttribute(clientId);
        writer.writeIdAttribute(clientId);
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)button);
        HtmlRendererUtils.renderTip((UIComponent)button, (TobagoResponseWriter)writer);
        writer.writeAttribute("disabled", helper.isDisabled());
        Integer tabIndex = button.getTabIndex();
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        if (helper.getOnclick() != null) {
            writer.writeAttribute("onclick", helper.getOnclick(), true);
        }
        Style style = new Style(facesContext, (LayoutBase)button);
        writer.writeStyleAttribute(style);
        HtmlRendererUtils.renderDojoDndItem((UIComponent)component, (TobagoResponseWriter)writer, (boolean)true);
        writer.writeClassAttribute(Classes.create((UIComponent)button));
        writer.flush();
        String image = (String)button.getAttributes().get("image");
        if (image != null) {
            if (!ResourceManagerUtils.isAbsoluteResource((String)image)) {
                image = this.getImageWithPath(facesContext, image, helper.isDisabled());
            }
            writer.startElement("img", null);
            writer.writeAttribute("src", image, true);
            String tip = button.getTip();
            writer.writeAttribute("alt", tip != null ? tip : "", true);
            writer.endElement("img");
        }
        if (label.getText() != null) {
            writer.startElement("span", null);
            HtmlRendererUtils.writeLabelWithAccessKey((TobagoResponseWriter)writer, (LabelWithAccessKey)label);
            writer.endElement("span");
        }
        writer.endElement("button");
        if (label.getAccessKey() != null) {
            if (LOG.isInfoEnabled() && !AccessKeyMap.addAccessKey((FacesContext)facesContext, (Character)label.getAccessKey())) {
                LOG.info("duplicated accessKey : " + label.getAccessKey());
            }
            HtmlRendererUtils.addClickAcceleratorKey((FacesContext)facesContext, (String)button.getClientId(facesContext), (char)label.getAccessKey().charValue());
        }
        if (ComponentUtils.getBooleanAttribute((UIComponent)component, (String)"defaultCommand")) {
            boolean transition = ComponentUtils.getBooleanAttribute((UIComponent)button, (String)"transition");
            HtmlRendererUtils.setDefaultTransition((FacesContext)facesContext, (boolean)transition);
            HtmlRendererUtils.writeScriptLoader((FacesContext)facesContext, null, (String[])new String[]{"Tobago.setDefaultAction('" + button.getClientId(facesContext) + "')"});
        }
    }

    private String createButtonType(UIComponent component) {
        boolean defaultCommand = ComponentUtils.getBooleanAttribute((UIComponent)component, (String)"defaultCommand");
        return defaultCommand ? "submit" : "button";
    }

    public Measure getPreferredWidth(FacesContext facesContext, Configurable component) {
        boolean image;
        UIButton button = (UIButton)component;
        Measure width = Measure.ZERO;
        boolean bl = image = button.getImage() != null;
        if (image) {
            width = this.getResourceManager().getThemeMeasure(facesContext, (Configurable)button, "imageWidth");
        }
        LabelWithAccessKey label = new LabelWithAccessKey((UIComponent)button);
        width = width.add(RenderUtils.calculateStringWidth((FacesContext)facesContext, (UIComponent)button, (String)label.getText()));
        Measure padding = this.getResourceManager().getThemeMeasure(facesContext, (Configurable)button, "paddingWidth");
        width = width.add(padding.multiply(image && label.getText() != null ? 3 : 2));
        return width;
    }
}

