/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.MethodExpressionValueChangeListener;
import javax.faces.event.ValueChangeListener;
import org.apache.myfaces.tobago.component.UINumberSlider;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NumberSliderTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(NumberSliderTag.class);
    private ValueExpression markup;
    private MethodExpression valueChangeListener;
    private ValueExpression value;
    private ValueExpression min;
    private ValueExpression max;
    private ValueExpression readonly;
    private ValueExpression disabled;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.NumberSlider";
    }

    public String getRendererType() {
        return "NumberSlider";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UINumberSlider component = (UINumberSlider)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf((String)this.markup.getExpressionString()));
            }
        }
        if (this.valueChangeListener != null) {
            component.addValueChangeListener((ValueChangeListener)new MethodExpressionValueChangeListener(this.valueChangeListener));
        }
        if (this.value != null) {
            component.setValueExpression("value", this.value);
        }
        if (this.min != null) {
            if (!this.min.isLiteralText()) {
                component.setValueExpression("min", this.min);
            } else {
                component.setMin(Integer.parseInt(this.min.getExpressionString()));
            }
        }
        if (this.max != null) {
            if (!this.max.isLiteralText()) {
                component.setValueExpression("max", this.max);
            } else {
                component.setMax(Integer.parseInt(this.max.getExpressionString()));
            }
        }
        if (this.readonly != null) {
            if (!this.readonly.isLiteralText()) {
                component.setValueExpression("readonly", this.readonly);
            } else {
                component.setReadonly(Boolean.parseBoolean(this.readonly.getExpressionString()));
            }
        }
        if (this.disabled != null) {
            if (!this.disabled.isLiteralText()) {
                component.setValueExpression("disabled", this.disabled);
            } else {
                component.setDisabled(Boolean.parseBoolean(this.disabled.getExpressionString()));
            }
        }
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public MethodExpression getValueChangeListener() {
        return this.valueChangeListener;
    }

    public void setValueChangeListener(MethodExpression valueChangeListener) {
        this.valueChangeListener = valueChangeListener;
    }

    public ValueExpression getValue() {
        return this.value;
    }

    public void setValue(ValueExpression value) {
        this.value = value;
    }

    public ValueExpression getMin() {
        return this.min;
    }

    public void setMin(ValueExpression min) {
        this.min = min;
    }

    public ValueExpression getMax() {
        return this.max;
    }

    public void setMax(ValueExpression max) {
        this.max = max;
    }

    public ValueExpression getReadonly() {
        return this.readonly;
    }

    public void setReadonly(ValueExpression readonly) {
        this.readonly = readonly;
    }

    public ValueExpression getDisabled() {
        return this.disabled;
    }

    public void setDisabled(ValueExpression disabled) {
        this.disabled = disabled;
    }

    public void release() {
        super.release();
        this.markup = null;
        this.valueChangeListener = null;
        this.value = null;
        this.min = null;
        this.max = null;
        this.readonly = null;
        this.disabled = null;
    }
}

