/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.application;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.tobago.application.FopConverter;
import org.apache.myfaces.tobago.internal.application.ViewHandlerImpl;
import org.apache.myfaces.tobago.internal.webapp.TobagoResponse;
import org.apache.myfaces.tobago.util.DebugUtils;
import org.apache.myfaces.tobago.util.VariableResolverUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoViewHandlerImpl
extends ViewHandlerImpl {
    private static final Logger LOG = LoggerFactory.getLogger(FoViewHandlerImpl.class);

    public FoViewHandlerImpl(ViewHandler base) {
        super(base);
    }

    public void renderView(FacesContext facesContext, UIViewRoot viewRoot) throws IOException, FacesException {
        String requestUri = viewRoot.getViewId();
        String contentType = VariableResolverUtils.resolveClientProperties((FacesContext)facesContext).getContentType();
        if (LOG.isDebugEnabled()) {
            LOG.debug("contentType = '" + contentType + "'");
        }
        if (contentType.indexOf("fo") == -1) {
            super.renderView(facesContext, viewRoot);
        } else {
            try {
                if (facesContext.getExternalContext().getResponse() instanceof TobagoResponse) {
                    ((TobagoResponse)((Object)facesContext.getExternalContext().getResponse())).setBuffering();
                    HttpServletRequest request = (HttpServletRequest)facesContext.getExternalContext().getRequest();
                    HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
                    RequestDispatcher requestDispatcher = request.getRequestDispatcher(requestUri);
                    requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
                    response.setContentType("application/pdf");
                    String buffer = ((TobagoResponse)((Object)facesContext.getExternalContext().getResponse())).getBufferedString();
                    ServletResponse servletResponse = (ServletResponse)facesContext.getExternalContext().getResponse();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("fo buffer: " + buffer);
                    }
                    FopConverter.fo2Pdf(servletResponse, buffer);
                }
            }
            catch (ServletException e) {
                IOException ex = new IOException();
                ex.initCause(e);
                throw ex;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("VIEW");
            LOG.debug(DebugUtils.toString((UIComponent)facesContext.getViewRoot(), (int)0));
        }
    }
}

