/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.fileupload;

import java.io.File;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.tobago.internal.util.JndiUtils;
import org.apache.myfaces.tobago.internal.webapp.TobagoMultipartFormdataRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadFacesContextFactoryImpl
extends FacesContextFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FileUploadFacesContextFactoryImpl.class);
    private FacesContextFactory facesContextFactory;
    private String repositoryPath = System.getProperty("java.io.tmpdir");
    private long maxSize = 0x100000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileUploadFacesContextFactoryImpl(FacesContextFactory facesContextFactory) {
        this.facesContextFactory = facesContextFactory;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Wrap FacesContext for file upload");
        }
        InitialContext ic = null;
        try {
            ic = new InitialContext();
            try {
                String repositoryPath = (String)JndiUtils.getJndiProperty((Context)ic, (String[])new String[]{"uploadRepositoryPath"});
                if (repositoryPath != null) {
                    File file = new File(repositoryPath);
                    if (!file.exists()) {
                        LOG.error("Given repository Path for " + ((Object)((Object)this)).getClass().getName() + " " + repositoryPath + " doesn't exists");
                    } else if (!file.isDirectory()) {
                        LOG.error("Given repository Path for " + ((Object)((Object)this)).getClass().getName() + " " + repositoryPath + " is not a directory");
                    } else {
                        this.repositoryPath = repositoryPath;
                    }
                }
            }
            catch (NamingException ne) {
                // empty catch block
            }
            try {
                String size = (String)JndiUtils.getJndiProperty((Context)ic, (String[])new String[]{"uploadMaxFileSize"});
                this.maxSize = TobagoMultipartFormdataRequest.getMaxSize((String)size);
            }
            catch (NamingException ne) {
                // empty catch block
            }
        }
        catch (NamingException e) {
        }
        finally {
            if (ic != null) {
                try {
                    ic.close();
                }
                catch (NamingException e) {}
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Configure uploadMaxFileSize for " + ((Object)((Object)this)).getClass().getName() + " to " + this.maxSize);
            LOG.info("Configure uploadRepositryPath for " + ((Object)((Object)this)).getClass().getName() + " to " + this.repositoryPath);
        }
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        String contentType;
        if (request instanceof HttpServletRequest && !(request instanceof TobagoMultipartFormdataRequest) && (contentType = ((HttpServletRequest)request).getContentType()) != null && contentType.toLowerCase().startsWith("multipart/form-data")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Wrap HttpServletRequest for file upload");
            }
            try {
                request = new TobagoMultipartFormdataRequest((HttpServletRequest)request, this.repositoryPath, this.maxSize);
            }
            catch (FacesException e) {
                LOG.error("", (Throwable)e);
                FacesContext facesContext = this.facesContextFactory.getFacesContext(context, request, response, lifecycle);
                FacesMessage facesMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, e.getCause().getMessage(), null);
                facesContext.addMessage(null, facesMessage);
                facesContext.renderResponse();
                return facesContext;
            }
        }
        return this.facesContextFactory.getFacesContext(context, request, response, lifecycle);
    }
}

