/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.speyside.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UIBox;
import org.apache.myfaces.tobago.component.UIMenuBar;
import org.apache.myfaces.tobago.config.Configurable;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.renderkit.BoxRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.renderkit.util.RenderUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class BoxRenderer
extends BoxRendererBase {
    public void prepareRender(FacesContext facesContext, UIComponent component) throws IOException {
        super.prepareRender(facesContext, component);
        HtmlRendererUtils.renderDojoDndSource((FacesContext)facesContext, (UIComponent)component);
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        UIBox box = (UIBox)component;
        String clientId = box.getClientId(facesContext);
        writer.startElement("div", (UIComponent)box);
        HtmlRendererUtils.renderDojoDndItem((UIComponent)box, (TobagoResponseWriter)writer, (boolean)true);
        writer.writeClassAttribute(Classes.create((UIComponent)box));
        writer.writeIdAttribute(clientId);
        String title = HtmlRendererUtils.getTitleFromTipAndMessages((FacesContext)facesContext, (UIComponent)box);
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        HtmlRendererUtils.writeDataAttributes((FacesContext)facesContext, (TobagoResponseWriter)writer, (UIComponent)box);
        writer.writeStyleAttribute(new Style(facesContext, (LayoutBase)box));
        this.encodeBox(facesContext, writer, box);
    }

    private void encodeBox(FacesContext facesContext, TobagoResponseWriter writer, UIBox box) throws IOException {
        UIPanel toolbar;
        Measure measure = this.getResourceManager().getThemeMeasure(facesContext, (Configurable)box, "shadow");
        boolean hasShadow = measure.greaterThan(Measure.ZERO);
        if (hasShadow) {
            writer.startElement("div", (UIComponent)box);
            writer.writeClassAttribute(Classes.create((UIComponent)box, (String)"shadow"));
            Style shadow = new Style();
            shadow.setWidth(box.getCurrentWidth().subtract(1));
            shadow.setHeight(box.getCurrentHeight().subtract(1));
            writer.writeStyleAttribute(shadow);
            writer.startElement("div", (UIComponent)box);
            writer.writeClassAttribute(Classes.create((UIComponent)box, (String)"border"));
            Style border = new Style();
            border.setWidth(box.getCurrentWidth().subtract(3));
            border.setHeight(box.getCurrentHeight().subtract(3));
            writer.writeStyleAttribute(border);
        }
        UIComponent label = box.getFacet("label");
        writer.startElement("div", null);
        writer.writeClassAttribute(Classes.create((UIComponent)box, (String)"header"));
        String labelString = (String)box.getAttributes().get("label");
        if (label != null) {
            RenderUtils.encode((FacesContext)facesContext, (UIComponent)label);
        } else if (labelString != null) {
            writer.writeText(labelString);
        }
        writer.endElement("div");
        UIMenuBar menuBar = this.getMenuBarFacet((UIComponent)box);
        if (menuBar != null) {
            RenderUtils.encode((FacesContext)facesContext, (UIComponent)menuBar);
        }
        if ((toolbar = (UIPanel)box.getFacet("toolBar")) != null) {
            this.renderToolbar(facesContext, writer, box, toolbar);
        }
        if (hasShadow) {
            writer.endElement("div");
            writer.endElement("div");
        }
        writer.startElement("div", null);
        writer.writeClassAttribute(Classes.create((UIComponent)box, (String)"content"));
        Style style = new Style(facesContext, (LayoutBase)box);
        Measure borderLeft = box.getBorderLeft();
        Measure borderRight = box.getBorderRight();
        Measure borderTop = box.getBorderTop();
        Measure borderBottom = box.getBorderBottom();
        style.setWidth(style.getWidth().subtract(borderLeft).subtract(borderRight));
        style.setHeight(style.getHeight().subtract(borderTop).subtract(borderBottom));
        style.setLeft(borderLeft);
        style.setTop(borderTop);
        writer.writeStyleAttribute(style);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter((FacesContext)facesContext);
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void renderToolbar(FacesContext facesContext, TobagoResponseWriter writer, UIBox box, UIPanel toolbar) throws IOException {
        writer.startElement("div", null);
        writer.writeClassAttribute(Classes.create((UIComponent)box, (String)"headerToolBar"));
        toolbar.setRendererType("BoxToolBar");
        RenderUtils.encode((FacesContext)facesContext, (UIComponent)toolbar);
        writer.endElement("div");
    }
}

