/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.tobago.taglib.component;

import org.apache.myfaces.tobago.apt.annotation.BodyContent;
import org.apache.myfaces.tobago.apt.annotation.Tag;
import org.apache.myfaces.tobago.apt.annotation.TagAttribute;
import org.apache.myfaces.tobago.apt.annotation.UIComponentTag;
import org.apache.myfaces.tobago.apt.annotation.UIComponentTagAttribute;
import org.apache.myfaces.tobago.taglib.decl.HasIdBindingAndRendered;

/*
 * Created: Aug 6, 2005 3:24:33 PM
 * User: bommel
 * $Id: CalendarTagDeclaration.java 1368577 2012-08-02 16:20:31Z lofwyr $
 */
/**
 * Renders a calendar.
 */
@Tag(name = "calendar", bodyContent = BodyContent.EMPTY)
@UIComponentTag(
    uiComponent = "javax.faces.component.UIOutput",
    rendererType = "Calendar", isComponentAlreadyDefined = true)
public interface CalendarTagDeclaration extends TobagoTagDeclaration, HasIdBindingAndRendered {

  /**
   * The current value of this component.
   */
  @TagAttribute
  @UIComponentTagAttribute(type = {"java.util.Calendar",
      "java.util.Date"})
  void setValue(String value);
}
