/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.context.ResourceManagerUtil;

public class MessageFactory {
    private static final Log LOG = LogFactory.getLog(MessageFactory.class);
    private static Map<Locale, ResourceBundle> facesMessagesMap = new HashMap<Locale, ResourceBundle>();

    public static FacesMessage createFacesMessage(FacesContext facesContext, String key, FacesMessage.Severity severity, Object[] args) {
        return MessageFactory.createFacesMessage(facesContext, "tobago", key, severity, args);
    }

    public static FacesMessage createFacesMessage(FacesContext facesContext, String key, FacesMessage.Severity severity) {
        return MessageFactory.createFacesMessage(facesContext, key, severity, new Object[0]);
    }

    public static FacesMessage createFacesMessage(FacesContext facesContext, String bundle, String key, FacesMessage.Severity severity, Object[] args) {
        String summary = MessageFactory.getMessageText(facesContext, bundle, key);
        String detail = MessageFactory.getMessageText(facesContext, bundle, key + "_detail");
        if (args != null && args.length > 0) {
            MessageFormat format;
            if (summary != null) {
                format = new MessageFormat(summary, facesContext.getViewRoot().getLocale());
                summary = format.format(args);
            }
            if (detail != null) {
                format = new MessageFormat(detail, facesContext.getViewRoot().getLocale());
                detail = format.format(args);
            }
        }
        return new FacesMessage(severity, summary != null ? summary : key, detail);
    }

    public static FacesMessage createFacesMessage(FacesContext facesContext, String bundle, String key, FacesMessage.Severity severity) {
        return MessageFactory.createFacesMessage(facesContext, bundle, key, severity, new Object[0]);
    }

    private static String getMessageText(FacesContext facesContext, String bundle, String key) {
        String message = ResourceManagerUtil.getProperty(facesContext, bundle, key);
        if (message == null || message.length() < 1) {
            try {
                Locale locale = facesContext.getViewRoot().getLocale();
                message = MessageFactory.getFacesMessages(locale).getString(key);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return message;
    }

    private static ResourceBundle getFacesMessages(Locale locale) {
        ResourceBundle facesMessages = facesMessagesMap.get(locale);
        if (facesMessages == null) {
            facesMessages = ResourceBundle.getBundle("javax.faces.Messages", locale);
            facesMessagesMap.put(locale, facesMessages);
        }
        return facesMessages;
    }
}

