/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.taglib.component;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.event.TabChangeEvent;
import org.apache.myfaces.tobago.event.TabChangeListener;
import org.apache.myfaces.tobago.event.TabChangeListenerValueBindingDelegate;
import org.apache.myfaces.tobago.event.TabChangeSource;

public class TabChangeListenerTag
extends TagSupport {
    private static final long serialVersionUID = -419199086962377873L;
    private static final Class[] TAB_CHANGE_LISTENER_ARGS = new Class[]{TabChangeEvent.class};
    private static final Log LOG = LogFactory.getLog(TabChangeListenerTag.class);
    private String type;
    private String binding;
    private String listener;

    public void setType(String type) {
        this.type = type;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    public void setListener(String listener) {
        this.listener = listener;
    }

    public int doStartTag() throws JspException {
        Object obj;
        UIComponentTag tag = UIComponentTag.getParentUIComponentTag((PageContext)this.pageContext);
        if (tag == null) {
            throw new JspException("Not nested in faces tag");
        }
        if (!tag.getCreated()) {
            return 0;
        }
        UIComponent component = tag.getComponentInstance();
        if (component == null) {
            throw new JspException("Component Instance is null");
        }
        if (!(component instanceof TabChangeSource)) {
            throw new JspException("Component " + component.getClass().getName() + " is not instanceof TabChangeSource");
        }
        TabChangeSource changeSource = (TabChangeSource)component;
        TabChangeListener handler = null;
        ValueBinding valueBinding = null;
        if (this.binding != null && UIComponentTag.isValueReference((String)this.binding) && (valueBinding = ComponentUtil.createValueBinding(this.binding)) != null && (obj = valueBinding.getValue(FacesContext.getCurrentInstance())) != null && obj instanceof TabChangeListener) {
            handler = (TabChangeListener)obj;
        }
        if (handler == null && this.type != null && (handler = this.createTabChangeListener(this.type)) != null && valueBinding != null) {
            valueBinding.setValue(FacesContext.getCurrentInstance(), (Object)handler);
        }
        if (handler != null) {
            if (valueBinding != null) {
                changeSource.addTabChangeListener(new TabChangeListenerValueBindingDelegate(this.type, valueBinding));
            } else {
                changeSource.addTabChangeListener(handler);
            }
        }
        if (this.listener != null && UIComponentTag.isValueReference((String)this.listener)) {
            Application application = FacesContext.getCurrentInstance().getApplication();
            MethodBinding methodBinding = application.createMethodBinding(this.listener, TAB_CHANGE_LISTENER_ARGS);
            changeSource.setTabChangeListener(methodBinding);
        }
        return 0;
    }

    public void release() {
        this.type = null;
        this.binding = null;
    }

    protected TabChangeListener createTabChangeListener(String className) throws JspException {
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
            return (TabChangeListener)clazz.newInstance();
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }
}

