/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.render.Renderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.config.ThemeConfig;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;
import org.apache.myfaces.tobago.renderkit.RenderUtil;

public class RendererBase
extends Renderer {
    protected static final Log LOG = LogFactory.getLog(LayoutableRendererBase.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        if (component instanceof UIInput) {
            LOG.warn((Object)("decode() should be overwritten! Renderer: " + ((Object)((Object)this)).getClass().getName()));
        }
    }

    public String getRendererName(String rendererType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("rendererType = '" + rendererType + "'"));
        }
        String name = rendererType;
        name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        return name;
    }

    public int getConfiguredValue(FacesContext facesContext, UIComponent component, String key) {
        try {
            return ThemeConfig.getValue(facesContext, component, key);
        }
        catch (Exception e) {
            LOG.error((Object)("Can't take '" + key + "' for " + ((Object)((Object)this)).getClass().getName() + " from config-file: " + e.getMessage()), (Throwable)e);
            return 0;
        }
    }

    protected String getCurrentValue(FacesContext facesContext, UIComponent component) {
        Object submittedValue;
        if (component instanceof UIInput && (submittedValue = ((UIInput)component).getSubmittedValue()) != null) {
            return (String)submittedValue;
        }
        String currentValue = null;
        Object currentObj = this.getValue(component);
        if (currentObj != null) {
            currentValue = RenderUtil.getFormattedValue(facesContext, component, currentObj);
        }
        return currentValue;
    }

    protected Object getValue(UIComponent component) {
        if (component instanceof ValueHolder) {
            return ((ValueHolder)component).getValue();
        }
        return null;
    }

    public Converter getConverter(FacesContext context, UIComponent component) {
        ValueBinding valueBinding;
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)component).getConverter();
        }
        if (converter == null && (valueBinding = component.getValueBinding("value")) != null) {
            Class converterType = valueBinding.getType(context);
            if (converterType == null || converterType == String.class || converterType == Object.class) {
                return null;
            }
            try {
                converter = context.getApplication().createConverter(converterType);
            }
            catch (FacesException e) {
                LOG.error((Object)("No Converter found for type " + converterType));
            }
        }
        return converter;
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (!(submittedValue instanceof String)) {
            return submittedValue;
        }
        Converter converter = this.getConverter(context, component);
        if (converter != null) {
            return converter.getAsObject(context, component, (String)submittedValue);
        }
        return submittedValue;
    }
}

