/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;

public class InputRendererBase
extends LayoutableRendererBase {
    private static final Log LOG = LogFactory.getLog(InputRendererBase.class);

    public void decode(FacesContext context, UIComponent component) {
        if (!(component instanceof UIInput)) {
            return;
        }
        UIInput uiInput = (UIInput)component;
        if (ComponentUtil.isOutputOnly(component)) {
            return;
        }
        String clientId = component.getClientId(context);
        Map requestParameterMap = context.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.containsKey(clientId)) {
            String newValue = (String)requestParameterMap.get(clientId);
            if (LOG.isDebugEnabled()) {
                boolean password = ComponentUtil.getBooleanAttribute(component, "password");
                LOG.debug((Object)("clientId = '" + clientId + "'"));
                LOG.debug((Object)("requestParameterMap.get(clientId) = '" + (password ? StringUtils.leftPad((String)"", (int)newValue.length(), (char)'*') : newValue) + "'"));
            }
            uiInput.setSubmittedValue((Object)newValue);
        }
    }

    public int getLabelWidth(FacesContext facesContext, UIComponent component) {
        return this.getConfiguredValue(facesContext, component, "labelWidth");
    }
}

