/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.layout;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.layout.Measure;

public final class PixelMeasure
extends Measure {
    private static final Log LOG = LogFactory.getLog(PixelMeasure.class);
    private static final PixelMeasure NULL = new PixelMeasure(0);
    private final int pixel;

    public PixelMeasure(int pixel) {
        this.pixel = pixel;
    }

    public Measure add(Measure m) {
        return new PixelMeasure(this.pixel + m.getPixel());
    }

    public Measure subtractNotNegative(Measure m) {
        if (m.getPixel() > this.pixel) {
            LOG.warn((Object)("Not enough space! value=" + this.pixel));
            return NULL;
        }
        return new PixelMeasure(this.pixel + m.getPixel());
    }

    @Deprecated
    public Measure substractNotNegative(Measure m) {
        return this.subtractNotNegative(m);
    }

    public int getPixel() {
        return this.pixel;
    }

    public String toString() {
        return this.pixel + "px";
    }
}

