/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.event;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.event.TabChangeEvent;
import org.apache.myfaces.tobago.event.TabChangeListener;

public class TabChangeListenerValueBindingDelegate
implements TabChangeListener,
StateHolder {
    private static final Log LOG = LogFactory.getLog(TabChangeListenerValueBindingDelegate.class);
    private String type;
    private ValueBinding valueBinding;

    public TabChangeListenerValueBindingDelegate() {
    }

    public TabChangeListenerValueBindingDelegate(String type, ValueBinding valueBinding) {
        this.type = type;
        this.valueBinding = valueBinding;
    }

    public void processTabChange(TabChangeEvent tabChangeEvent) {
        TabChangeListener handler = this.getTabChangeListener();
        if (handler != null) {
            handler.processTabChange(tabChangeEvent);
        } else {
            LOG.error((Object)"Ignoring TabChangeEvent. No TabChangeListener found.");
        }
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.valueBinding), this.type};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.valueBinding = (ValueBinding)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[0]);
        this.type = (String)values[1];
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean newTransientValue) {
    }

    private TabChangeListener getTabChangeListener() {
        Object obj;
        TabChangeListener handler = null;
        if (this.valueBinding != null && (obj = this.valueBinding.getValue(FacesContext.getCurrentInstance())) != null && obj instanceof TabChangeListener) {
            handler = (TabChangeListener)obj;
        }
        if (handler == null && this.type != null && (handler = this.createTabChangeListener(this.type)) != null && this.valueBinding != null) {
            this.valueBinding.setValue(FacesContext.getCurrentInstance(), (Object)handler);
        }
        return handler;
    }

    private TabChangeListener createTabChangeListener(String className) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
            return (TabChangeListener)clazz.newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)"", (Throwable)e);
            return null;
        }
    }
}

