/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.myfaces.tobago.config.TobagoConfig;
import org.apache.myfaces.tobago.context.ResourceLocator;
import org.apache.myfaces.tobago.context.ResourceManager;
import org.apache.myfaces.tobago.context.ResourceManagerImpl;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.context.ThemeBuilder;

public class ResourceManagerFactory {
    public static final String RESOURCE_MANAGER = "org.apache.myfaces.tobago.context.ResourceManager";
    private static boolean initialized;

    private ResourceManagerFactory() {
    }

    public static ResourceManager getResourceManager(FacesContext facesContext) {
        assert (initialized);
        return (ResourceManager)facesContext.getExternalContext().getApplicationMap().get(RESOURCE_MANAGER);
    }

    public static ResourceManager getResourceManager(ServletContext servletContext) {
        assert (initialized);
        return (ResourceManager)servletContext.getAttribute(RESOURCE_MANAGER);
    }

    public static void init(ServletContext servletContext, TobagoConfig tobagoConfig) throws ServletException {
        assert (!initialized);
        ResourceManagerImpl resourceManager = new ResourceManagerImpl(tobagoConfig);
        ThemeBuilder themeBuilder = new ThemeBuilder();
        ResourceLocator resourceLocator = new ResourceLocator(servletContext, resourceManager, themeBuilder);
        resourceLocator.locate();
        Map<String, Theme> availableThemes = themeBuilder.resolveThemes(tobagoConfig.getRenderersConfig());
        tobagoConfig.setAvailableThemes(availableThemes);
        for (Theme theme : availableThemes.values()) {
            tobagoConfig.addResourceDir(theme.getResourcePath());
        }
        servletContext.setAttribute(RESOURCE_MANAGER, (Object)resourceManager);
        initialized = true;
    }

    public static void release(ServletContext servletContext) {
        assert (initialized);
        initialized = false;
        servletContext.removeAttribute(RESOURCE_MANAGER);
    }
}

