/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.config.MappingRule;
import org.apache.myfaces.tobago.context.RenderersConfig;
import org.apache.myfaces.tobago.context.Theme;
import org.apache.myfaces.tobago.util.Deprecation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TobagoConfig {
    private static final Log LOG = LogFactory.getLog(TobagoConfig.class);
    public static final String TOBAGO_CONFIG = "org.apache.myfaces.tobago.config.TobagoConfig";
    private List<Theme> supportedThemes;
    private List<String> supportedThemeNames = new ArrayList<String>();
    private Theme defaultTheme;
    private String defaultThemeName;
    private List<String> resourceDirs;
    private List<MappingRule> mappingRules;
    private boolean ajaxEnabled = true;
    private boolean fixResourceOrder = false;
    private boolean fixLayoutTransparency = false;
    private boolean createSessionSecret = false;
    private boolean checkSessionSecret = false;
    private Map<String, Theme> availableTheme;
    private RenderersConfig renderersConfig;

    public TobagoConfig() {
        this.supportedThemes = new ArrayList<Theme>();
        this.resourceDirs = new ArrayList<String>();
    }

    public void addMappingRule(MappingRule mappingRule) {
        Deprecation.LOG.warn((Object)"mapping rules are deprecated");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addMappingRule: {" + mappingRule + "}"));
        }
        if (this.mappingRules == null) {
            this.mappingRules = new ArrayList<MappingRule>();
        }
        this.mappingRules.add(mappingRule);
    }

    public void addSupportedThemeName(String name) {
        this.supportedThemeNames.add(name);
    }

    public void resolveThemes() {
        this.defaultTheme = this.availableTheme.get(this.defaultThemeName);
        this.checkThemeIsAvailable(this.defaultThemeName, this.defaultTheme);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("name = '" + this.defaultThemeName + "'"));
            LOG.debug((Object)("defaultTheme = '" + this.defaultTheme + "'"));
        }
        for (String name : this.supportedThemeNames) {
            Theme theme = this.availableTheme.get(name);
            this.checkThemeIsAvailable(name, theme);
            this.supportedThemes.add(theme);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("name = '" + name + "'"));
            LOG.debug((Object)("supportedThemes.last() = '" + this.supportedThemes.get(this.supportedThemes.size() - 1) + "'"));
        }
    }

    private void checkThemeIsAvailable(String name, Theme theme) {
        if (theme == null) {
            String error = "Theme not found! name: '" + name + "'. " + "Please ensure you have a tobago-theme.xml file in your " + "theme jar. Found the following themes: " + this.availableTheme.keySet();
            LOG.error((Object)error);
            throw new RuntimeException(error);
        }
    }

    public static TobagoConfig getInstance(FacesContext facesContext) {
        return (TobagoConfig)facesContext.getExternalContext().getApplicationMap().get(TOBAGO_CONFIG);
    }

    public static TobagoConfig getInstance(ServletContext servletContext) {
        return (TobagoConfig)servletContext.getAttribute(TOBAGO_CONFIG);
    }

    public MappingRule getMappingRule(String requestUri) {
        Iterator<MappingRule> i = this.getMappingRules();
        while (i.hasNext()) {
            MappingRule rule = i.next();
            if (!rule.getRequestUri().equals(requestUri)) continue;
            return rule;
        }
        return null;
    }

    public Iterator<MappingRule> getMappingRules() {
        if (this.mappingRules == null) {
            List objects = Collections.emptyList();
            return objects.iterator();
        }
        return this.mappingRules.iterator();
    }

    public Theme getTheme(String name) {
        if (name == null) {
            LOG.debug((Object)"searching theme: null");
            return this.defaultTheme;
        }
        if (this.defaultTheme.getName().equals(name)) {
            return this.defaultTheme;
        }
        for (Theme theme : this.supportedThemes) {
            if (!theme.getName().equals(name)) continue;
            return theme;
        }
        LOG.debug((Object)("searching theme '" + name + "' not found. " + "Using default: " + this.defaultTheme));
        return this.defaultTheme;
    }

    public void setDefaultThemeName(String defaultThemeName) {
        this.defaultThemeName = defaultThemeName;
    }

    public List<Theme> getSupportedThemes() {
        return Collections.unmodifiableList(this.supportedThemes);
    }

    public void addResourceDir(String resourceDir) {
        if (!this.resourceDirs.contains(resourceDir)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("adding resourceDir = '" + resourceDir + "'"));
            }
            this.resourceDirs.add(resourceDir);
        }
    }

    public List<String> getResourceDirs() {
        return this.resourceDirs;
    }

    public boolean isAjaxEnabled() {
        return this.ajaxEnabled;
    }

    public void setAjaxEnabled(String value) {
        this.ajaxEnabled = Boolean.valueOf(value);
    }

    public boolean isFixResourceOrder() {
        return this.fixResourceOrder;
    }

    public void setFixResourceOrder(String fixResourceOrder) {
        this.fixResourceOrder = Boolean.valueOf(fixResourceOrder);
    }

    public boolean isFixLayoutTransparency() {
        return this.fixLayoutTransparency;
    }

    public void setFixLayoutTransparency(String fixLayoutTransparency) {
        this.fixLayoutTransparency = Boolean.valueOf(fixLayoutTransparency);
    }

    public boolean isCreateSessionSecret() {
        return this.createSessionSecret;
    }

    public void setCreateSessionSecret(String createSessionSecret) {
        this.createSessionSecret = Boolean.valueOf(createSessionSecret);
    }

    public boolean isCheckSessionSecret() {
        return this.checkSessionSecret;
    }

    public void setCheckSessionSecret(String checkSessionSecret) {
        this.checkSessionSecret = Boolean.valueOf(checkSessionSecret);
    }

    @Deprecated
    public void setLoadThemesFromClasspath(String loadThemesFromClasspath) {
        Deprecation.LOG.error((Object)"Deprecated: setting load-theme-resources-from-classpath is no longer supported");
    }

    public Theme getDefaultTheme() {
        return this.defaultTheme;
    }

    public void setAvailableThemes(Map<String, Theme> availableTheme) {
        this.availableTheme = availableTheme;
    }

    public RenderersConfig getRenderersConfig() {
        return this.renderersConfig;
    }

    public void setRenderersConfig(RenderersConfig renderersConfig) {
        this.renderersConfig = renderersConfig;
    }
}

