/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.config;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.tobago.component.ComponentUtil;
import org.apache.myfaces.tobago.context.ClientProperties;
import org.apache.myfaces.tobago.context.ResourceManager;
import org.apache.myfaces.tobago.context.ResourceManagerFactory;
import org.apache.myfaces.tobago.renderkit.LayoutableRendererBase;
import org.apache.myfaces.tobago.renderkit.RendererBase;

public class ThemeConfig {
    private static final Log LOG = LogFactory.getLog(ThemeConfig.class);
    public static final String THEME_CONFIG_CACHE = "org.apache.myfaces.tobago.config.ThemeConfig.CACHE";
    private static final Integer NULL_VALUE = Integer.MIN_VALUE;

    public static int getValue(FacesContext facesContext, UIComponent component, String name) {
        CacheKey key = new CacheKey(facesContext.getViewRoot(), component, name);
        Map cache = (Map)facesContext.getExternalContext().getApplicationMap().get(THEME_CONFIG_CACHE);
        Integer value = (Integer)cache.get(key);
        if (value == null) {
            value = ThemeConfig.createValue(facesContext, component, name);
            if (value == null) {
                value = NULL_VALUE;
            }
            cache.put(key, value);
        }
        if (!NULL_VALUE.equals(value)) {
            return value;
        }
        if (!ClientProperties.getInstance(facesContext.getViewRoot()).getContentType().equals("wml")) {
            throw new NullPointerException("No value configured");
        }
        return 0;
    }

    public static boolean hasValue(FacesContext facesContext, UIComponent component, String name) {
        try {
            ThemeConfig.getValue(facesContext, component, name);
            return true;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    private static Integer createValue(FacesContext facesContext, UIComponent component, String name) {
        String rendererType;
        String family;
        if (component != null) {
            family = component.getFamily();
            rendererType = component.getRendererType();
        } else {
            family = "javax.faces.Input";
            rendererType = "In";
        }
        LayoutableRendererBase renderer = ComponentUtil.getRenderer(facesContext, family, rendererType);
        Class<?> clazz = renderer.getClass();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("search for '" + name + "' in '" + clazz.getName() + "'"));
        }
        ResourceManager resourceManager = ResourceManagerFactory.getResourceManager(facesContext);
        UIViewRoot viewRoot = facesContext.getViewRoot();
        while (clazz != null) {
            String property;
            String tag = ThemeConfig.getTagName(clazz);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("try " + tag));
            }
            if ((property = resourceManager.getThemeProperty(viewRoot, "tobago-theme-config", tag + "." + name)) != null && property.length() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("found " + property));
                }
                return new Integer(property);
            }
            clazz = clazz.getSuperclass();
        }
        if (!ClientProperties.getInstance(viewRoot).getContentType().equals("wml")) {
            LOG.error((Object)("Theme property '" + name + "' not found for renderer: " + renderer.getClass() + " with clientProperties='" + ClientProperties.getInstance(viewRoot).getId() + "'" + " and locale='" + viewRoot.getLocale() + "'"));
        }
        return null;
    }

    private static String getTagName(Class clazz) {
        String className = ClassUtils.getShortClassName((Class)clazz);
        if (className.equals(ClassUtils.getShortClassName(RendererBase.class))) {
            return "Tobago";
        }
        if (className.endsWith("Renderer")) {
            return className.substring(0, className.lastIndexOf("Renderer"));
        }
        if (className.endsWith("RendererBase")) {
            return className.substring(0, className.lastIndexOf("RendererBase")) + "Base";
        }
        return null;
    }

    public static void init(ServletContext servletContext) {
        servletContext.setAttribute(THEME_CONFIG_CACHE, new ConcurrentHashMap(100, 0.75f, 1));
    }

    public static void shutdown(ServletContext servletContext) {
        Map cache = (Map)servletContext.getAttribute(THEME_CONFIG_CACHE);
        cache.clear();
        servletContext.removeAttribute(THEME_CONFIG_CACHE);
    }

    private static class CacheKey {
        private String clientProperties;
        private Locale locale;
        private String rendererType;
        private String name;

        public CacheKey(UIViewRoot viewRoot, UIComponent component, String name) {
            this.clientProperties = ClientProperties.getInstance(viewRoot).getId();
            this.locale = viewRoot.getLocale();
            this.rendererType = component != null ? component.getRendererType() : "DEFAULT";
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.clientProperties.equals(cacheKey.clientProperties)) {
                return false;
            }
            if (!this.locale.equals(cacheKey.locale)) {
                return false;
            }
            if (!this.name.equals(cacheKey.name)) {
                return false;
            }
            return this.rendererType.equals(cacheKey.rendererType);
        }

        public int hashCode() {
            int result = this.clientProperties.hashCode();
            result = 29 * result + this.locale.hashCode();
            result = 29 * result + this.rendererType.hashCode();
            result = 29 * result + this.name.hashCode();
            return result;
        }
    }
}

